/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An abstract superclass of renderers used for bars, points and pie segments.
 */
public abstract class AbstractRenderer {

	public static final String PROPERTY_OUTLINE_WIDTH = "Outline Width";

	protected static final int ROLLOVER_INTENSITY = 50;

	protected java.beans.PropertyChangeSupport support;

	protected boolean alwaysShowOutlines;

	public AbstractRenderer() {
	}

	/**
	 *  @return the color used by this renderer when indicating selections
	 */
	public java.awt.Color getSelectionColor() {
	}

	/**
	 *  Set the color used for indicating the selection of items.
	 *  The default is the value held by Swing's UIManager under the key "Chart.selectionBackground", or if this is null
	 *  then Color.orange is used.
	 *  @param selectionColor the color to use for indicating selections
	 */
	public void setSelectionColor(java.awt.Color selectionColor) {
	}

	public java.awt.Color getOutlineColor() {
	}

	public void setOutlineColor(java.awt.Color outlineColor) {
	}

	/**
	 *  @return the width (in pixels) used by this renderer when outlining shapes
	 */
	public float getOutlineWidth() {
	}

	/**
	 *  Set the width of the line used for outlining rendered shapes
	 *  @param outlineWidth the width in pixels
	 */
	public void setOutlineWidth(float outlineWidth) {
	}

	/**
	 *  Add the supplied property listener to this object
	 *  @param listener a PropertyChangeListener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove the supplied property change listener
	 *  @param listener the PropertyChangeListener to remove
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Should we always show outlines, even when we are not showing outlines for selection?
	 */
	public boolean isAlwaysShowOutlines() {
	}

	/**
	 *  Specify whether to always draw an outline, regardless whether the object is selected
	 *  @param alwaysShowOutlines boolean flag setting to indicate whether outlines should always be shown
	 */
	public void setAlwaysShowOutlines(boolean alwaysShowOutlines) {
	}
}
