/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  A class that renderers a three dimensional 'platform'-like axis.
 */
public class Axis3DRenderer implements AxisRenderer {

	/**
	 *  Create an Axis3DRenderer
	 */
	public Axis3DRenderer() {
	}

	/**
	 *  Returns the angle in degrees currently used for the z axis lines in the Axis3DRenderer
	 * 
	 *  @return the angle in degrees used when drawing z axis lines
	 */
	public double getAngle() {
	}

	/**
	 *  Specify the angle in degrees for the z axis lines in the 3D axis 'platform'. Default is 35 degrees.
	 * 
	 *  @param angle the angle in degrees for the z axis lines
	 */
	public void setAngle(double angle) {
	}

	public double getDepthProportion() {
	}

	/**
	 *  Specify how much of the available breadth the axis will use. Default value is 1.0
	 * 
	 *  @param depthProportion specifies depth as a proportion of the available space
	 */
	public void setDepthProportion(double depthProportion) {
	}

	/**
	 *  Returns the breadth of the axis
	 * 
	 *  @return the breadth of the axis
	 */
	public int getBreadth() {
	}

	/**
	 *  Specify the breadth of the axis
	 * 
	 *  @param breadth the new breadth of the axis
	 */
	public void setBreadth(int breadth) {
	}

	/**
	 *  Returns the height of the front of the 3D axis, either by simply returning the value provided
	 *  in the setter, or if null, by calculating a value based on the frontHeightProportion.
	 * 
	 *  @return the height of the front of the 3D axis in pixels
	 */
	public int getFrontHeight() {
	}

	/**
	 *  This method enables you to specify the front height of the 3D axis in terms of pixels.
	 *  If the frontHeight value supplied here is null (the default value) then the frontHeight is
	 *  calculated using the frontHeightProportion. Otherwise a non-null value has been supplied and
	 *  that value will be used as a fixed pixel height.
	 * 
	 *  @param frontHeight the height of the front of the axis in pixels, or null if it is to be
	 *                     calculated from the frontHeightProportion.
	 */
	public void setFrontHeight(Integer frontHeight) {
	}

	/**
	 *  Set a height for the front of the 3D axis as a proportion of the available space.
	 * 
	 *  @param frontHeightProportion the height of the front of the 3D axis as a proportion of the available space
	 */
	public void setFrontHeightProportion(double frontHeightProportion) {
	}

	public ZAlignment getZAlignment() {
	}

	public void setZAlignment(ZAlignment zAlignment) {
	}

	/**
	 *  When rendering horizontally the supplied y coordinate is the centre of the rendered breadth
	 */
	public void renderAxis(java.awt.Graphics g, int x, int y, int length, com.jidesoft.chart.Orientation orientation) {
	}
}
