/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface implemented by all axis renderers. Axis rendering does not include the rendering of axis labels
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface AxisRenderer {

	/**
	 *  @return the breadth of the axis in pixels. <p>For an axis that is rendered horizontally the breadth is its
	 *          height. for an axis that is rendered vertically, its breadth is its width.</p>
	 */
	public int getBreadth();

	public void setBreadth(int breadth);

	public void renderAxis(java.awt.Graphics g, int x, int y, int length, com.jidesoft.chart.Orientation orientation);
}
