/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface implemented by classes that can be used to render the bars of a bar chart
 */
public interface BarRenderer2D extends BarRenderer {

	public int getMinimumBreadth();

	/**
	 *  There is one call to this method for each bar to be rendered in a bar chart.
	 *  @param g the graphics context onto which the bar is drawn
	 *  @param chart the chart object
	 *  @param m the chart model from which the bar/point comes
	 *  @param p the point of the model corresponding to the bar
	 *  @param isSelected whether the bar is currently selected
	 *  @param hasRollover whether the bar currently is under the mouse cursor
	 *  @param hasFocus whether the bar currently has focus (not yet supported)
	 *  @param x the x pixel coordinate for the top left of the bar
	 *  @param y the y pixel coordinate for the top left of the bar
	 *  @param width the width of the bar in pixels
	 *  @param height the height of the bar in pixels
	 */
	public java.awt.Shape renderBar(java.awt.Graphics2D g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable p, boolean isSelected, boolean hasRollover, boolean hasFocus, double x, double y, double width, double height);
}
