/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  Used by the CandlestickPointRenderer to specify what kind of candlestick chart to draw for financial
 *  OHLC (Open-High-Low-Close) data.
 *  @see com.jidesoft.chart.render.CandlestickPointRenderer
 *  @see com.jidesoft.chart.model.ChartPointOHLC
 */
public final class CandlestickChartType extends Enum {

	/**
	 *  Traditional OHLC candlesticks
	 */
	public static final CandlestickChartType BAR;

	/**
	 *  Simple lines to indicate OHLC data
	 */
	public static final CandlestickChartType LINE;

	/**
	 *  Render rectangles as for a three line break chart
	 *  (can also be used for 4 line break charts or similar).
	 */
	public static final CandlestickChartType TLB;

	public static CandlestickChartType[] values() {
	}

	public static CandlestickChartType valueOf(String name) {
	}
}
