/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  Renderer for a candlestick chart
 */
public class CandlestickPointRenderer extends AbstractPointRenderer {

	public static final String PROPERTY_CANDLESTICK_TYPE = "Candlestick Type";

	/**
	 *  Zero argument constructor
	 */
	public CandlestickPointRenderer() {
	}

	/**
	 *  Creates a Candlestick renderer and simultaneously sets the style of rendering
	 *  @param candlestickType the new style of rendering to use
	 */
	public CandlestickPointRenderer(CandlestickChartType candlestickType) {
	}

	/**
	 *  @return the style of candlestick currently rendered by this object
	 */
	public CandlestickChartType getCandlestickType() {
	}

	/**
	 *  Returns the length of the ticks in proportion to the corresponding time
	 *  range when using CandlestickChartType.LINE
	 *  @return the length of ticks in proportion to the time range
	 */
	public double getLineTickLengthProportion() {
	}

	/**
	 *  When rendering the candlestick as CandlestickChartType.LINE, this property
	 *  specifies the length of the tick line as a proportion of the gap between
	 *  the opening time point and the closing time point. By default, this value
	 *  is 0.5
	 *  @param lineTickLengthProportion the length of the tick in a LINE candlestick
	 *                                  chart
	 */
	public void setLineTickLengthProportion(double lineTickLengthProportion) {
	}

	/**
	 *  Returns the length of candlestick tick marks in pixels (if used).
	 *  The default is to use a tick length proportion, but this property can be used to override that
	 *  behaviour and set a fixed length.
	 *  @return the length of the ticks in line-style candlesticks
	 */
	public Integer getTickLength() {
	}

	/**
	 *  If you prefer not to have proportional tick lengths for line-style candlesticks, but want to set a fixed tick
	 *  length instead, you can set this property, which will override the lineTickLengthProportion property.
	 *  @param tickLength the length of tick marks in pixels
	 */
	public void setTickLength(Integer tickLength) {
	}

	/**
	 *  Specify the style of rendering used for candlesticks
	 *  @param candlestickType the style of rendering to use
	 */
	public void setCandlestickType(CandlestickChartType candlestickType) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public java.awt.Shape renderPoint(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable point, boolean isSelected, boolean hasRollover, boolean hasFocus, int x, int y) {
	}
}
