/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  This renderer takes account of negative heights. If a negative height is supplied, then the y coordinate and height
 *  are adjusted so that the height becomes positive and the shape is paintable. <p>NOTE: Widths are currently assumed to
 *  be positive</p>
 */
public class CylinderBarRenderer extends AbstractBarRenderer implements BarRenderer2D {

	public CylinderBarRenderer() {
	}

	/**
	 *  returns the depth of a cylinder as a proportion of its width
	 *  @return the depth of a cylinder as a proportion of its width
	 */
	public double getDepthRatio() {
	}

	/**
	 *  Specify the depth of the cylinder as a proportion of its width; default value is 0.23
	 *  @param depthRatio the depth of the cylinder as a proportion of its width
	 */
	public void setDepthRatio(double depthRatio) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public java.awt.Shape renderBar(java.awt.Graphics2D g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable p, boolean isSelected, boolean hasRollover, boolean hasFocus, double x, double y, double width, double height) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public java.awt.Shape renderBar(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable p, boolean isSelected, boolean hasRollover, boolean hasFocus, int x, int y, int width, int height) {
	}

	protected java.awt.Paint createFrontPaint(com.jidesoft.chart.Orientation orientation, java.awt.Color color, int x, int y, int width, int height, int depth) {
	}

	protected java.awt.Paint createTopPaint(com.jidesoft.chart.Orientation orientation, java.awt.Color color, int x, int y, int width, int height, int depth) {
	}

	protected java.awt.Color darker(java.awt.Color color) {
	}

	protected java.awt.Color brighter(java.awt.Color color) {
	}

	public int getMinimumBreadth() {
	}
}
