/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  A renderer for drawing lines on a chart. Consecutive points in the ChartModel are joined by
 *  straight line segments.
 */
public class DefaultLineRenderer extends AbstractLineRenderer {

	public static final String PROPERTY_CHART = "Chart";

	public static final String PROPERTY_USE_DRAW_POLYLINE = "Use DrawPolyline";

	/**
	 *  Creates a DefaultLineRenderer using the supplied chart object as the chart object onto which
	 *  lines should be drawn.
	 *  @param chart the chart object
	 */
	public DefaultLineRenderer(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Returns the chart associated with this renderer
	 *  @return the chart object associated with this renderer
	 */
	public com.jidesoft.chart.Chart getChart() {
	}

	/**
	 *  Sets the chart onto which the lines should be drawn
	 *  @param chart the Chart object
	 */
	public void setChart(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Returns whether we are using the <code>drawPolyLine()</code> method for calls on the Graphics context to draw
	 *  lines
	 *  @return whether we are using drawPolyline for calls on the Graphics context to draw lines
	 */
	public boolean getUseDrawPolyline() {
	}

	/**
	 *  Specify whether to use drawPolyline() to paint multiple line segments. The choice of this
	 *  parameter can affect performance, particularly for larger data sets.
	 *  @param useDrawPolyline boolean value to indicate whether to use drawPolyline on the underlying platform.
	 *                         If set to false (the default), the chart package will iterate through the line
	 *                         segments to be drawn.
	 */
	public void setUseDrawPolyline(boolean useDrawPolyline) {
	}

	/**
	 *  Adds a property change listener to this object
	 *  @param listener a property change listener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove the supplied property change listener from this object
	 *  @param listener the property change listener to remove
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.SuppressWarnings("cast")
	public java.awt.Shape renderLine(java.awt.Graphics g, com.jidesoft.chart.model.ChartModel m, int[] xPoints, int[] yPoints, com.jidesoft.chart.style.ChartStyle style) {
	}
}
