/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  A pie label renderer that draws lines from the label to its corresponding segment in the pie chart.
 */
public class LinePieLabelRenderer extends AbstractPieLabelRenderer implements PieLabelRenderer2D {

	public LinePieLabelRenderer() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public PointLabeler getPointLabeler() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void setPointLabeler(PointLabeler pointLabeler) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public int getTickLength() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void setTickLength(int tickLength) {
	}

	public int getSegmentControlPointDistance() {
	}

	public void setSegmentControlPointDistance(int segmentControlPointDistance) {
	}

	public int getLabelControlPointDistance() {
	}

	public void setLabelControlPointDistance(int labelControlPointDistance) {
	}

	/**
	 *  Returns the distance between the end of the label and the start of the line leading to the segment
	 *  @return the distance between the end of the label and the start of the line leading to the segment
	 */
	public int getLabelLineGapSize() {
	}

	/**
	 *  Specify the distance between the end of the label and the start of the line leading to the segment
	 *  @param labelLineGapSize the gap in pixels between the end of the label and the start of the line pointing to the segment
	 */
	public void setLabelLineGapSize(int labelLineGapSize) {
	}

	/**
	 *  Returns the color of the line that joins the label to the pie segment
	 *  @return the color of the line that joins the label to the pie segment
	 */
	public java.awt.Color getLineColor() {
	}

	/**
	 *  Specify the color of the line that joins the label to the pie segment
	 *  @param lineColor the color of the line that joins the label to the pie segment
	 */
	public void setLineColor(java.awt.Color lineColor) {
	}

	/**
	 *  This method is called to determine the line color. By default it just calls getLineColor() but you can override
	 *  this so that it returns a different color for each segment of the pie, if required. One way of doing this is to get
	 *  the highlight associated with the point and fetch the ChartStyle, so that the line color can be used.
	 *  @return the Color to use
	 */
	protected java.awt.Color createLineColor(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, com.jidesoft.chart.model.Chartable p) {
	}

	protected java.awt.Color createLabelColor(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, com.jidesoft.chart.model.Chartable p) {
	}

	protected java.awt.Font createLabelFont(com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, com.jidesoft.chart.model.Chartable p) {
	}

	public java.awt.Stroke getLineStroke() {
	}

	public void setLineStroke(java.awt.Stroke lineStroke) {
	}

	public int getLabelXOffset() {
	}

	/**
	 *  Specifies the distance that the labels are offset from the pie in the x direction
	 *  @param labelXOffset the distance in pixels
	 */
	public void setLabelXOffset(int labelXOffset) {
	}

	public boolean isShowAllLabels() {
	}

	public void setShowAllLabels(boolean showAllLabels) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void renderLabels(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.Point center, int width, int height, int[] angles, com.jidesoft.chart.style.ChartStyle style) {
	}

	public void renderLabels(java.awt.Graphics2D g2d, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.geom.Point2D center, double width, double height, float[] angles, com.jidesoft.chart.style.ChartStyle style) {
	}

	public void layout(java.util.List labels) {
	}
}
