/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface for classes that can be used to render lines in a Chart
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface LineRenderer {

	/**
	 *  Render lines using the supplied arrays of x and y pixel coordinates onto the supplied Graphics context.
	 *  @param g the Graphics context
	 *  @param m the ChartModel from which the points originated
	 *  @param xPoints an array of x coordinates
	 *  @param yPoints an array of y coordinates
	 *  @param style the suggested style for rendering (a custom renderer may choose to ignore this)
	 */
	public java.awt.Shape renderLine(java.awt.Graphics g, com.jidesoft.chart.model.ChartModel m, int[] xPoints, int[] yPoints, com.jidesoft.chart.style.ChartStyle style);
}
