/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface for classes that can take a chartable point and generate the text to use for the label
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface NumberLabeler {

	/**
	 *  Create the text to use for the label for the supplied point
	 *  @param position the numeric value for which we need some display text for a label
	 *  @return the text
	 */
	public String getDisplayText(Number position);
}
