/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  A 3D Pie chart renderer
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class Pie3DRenderer extends AbstractPieSegmentRenderer implements PieSegmentRenderer2D {

	public Pie3DRenderer() {
	}

	/**
	 *  Returns the thickness of the pie chart as a ratio of the pie diameter
	 *  @return the thickness of the pie chart as a ratio of the pie diameter
	 */
	public float getThicknessRatio() {
	}

	/**
	 *  Specify the thickness of the pie chart as a ratio of the pie diameter.
	 *  By default, this has a value of 0.2
	 *  @param thicknessRatio the thickness of the pie chart as a ratio of the pie diameter
	 */
	public void setThicknessRatio(float thicknessRatio) {
	}

	/**
	 *  Get the three spotlight ratio values
	 *  @return an array of 4 floats used for the spotlight colour ratio values
	 */
	public float[] getSpotlightRatios() {
	}

	/**
	 *  Set four brightness ratios used to apply to colours on the main surface of the pie chart to give
	 *  a spotlight effect. A ratio of 0.5 leaves the input color unchanged, larger values make the color
	 *  brighter and smaller values make the color dimmer. The default value is {0.48f, 0.49f, 0.5f, 0.53f}
	 *  @param ratios the new brightness ratios
	 */
	public void setSpotlightRatios(float[] ratios) {
	}

	public void renderSegments(java.awt.Graphics2D g2d, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, java.awt.geom.Point2D center, float radius, float[] angles) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void renderSegments(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, java.awt.Point center, int radius, int[] angles) {
	}

	/**
	 *  Renders the outlines for a 3d pie chart, only when rollover is activated
	 *  @param isForSelection there are two reasons or modes in which this method is invoked:
	 *  one is for rendering outlines because it has been specified that outlines should always
	 *  be displayed; and the other is for rendering an outline because it has been selected.
	 *  If we call this method for the latter reason, this parameter is true.
	 *  @param g2d the graphics context
	 *  @param chart the chart component
	 *  @param model the chart model for which we are rendering outlines
	 *  @param center the center of the ellipse for which this is a segment
	 *  @param w the width of the ellipse
	 *  @param h the height of the ellipse
	 *  @param angles an array of angles
	 *  @param style style hints for the display (currently unused) 
	 */
	protected void renderOutlines(boolean isForSelection, java.awt.Graphics2D g2d, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.Point center, int w, int h, int[] angles, com.jidesoft.chart.style.ChartStyle style) {
	}

	protected void renderOutlines2D(boolean isForSelection, java.awt.Graphics2D g2d, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.geom.Point2D center, int w, int h, float[] angles, com.jidesoft.chart.style.ChartStyle style) {
	}
}
