/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface implemented by objects that are responsible for painting the labels of a pie chart
 */
public interface PieLabelRenderer {

	/**
	 *  Set the object responsible for specifying what the labels should say
	 */
	public void setPointLabeler(PointLabeler pointLabeler);

	/**
	 *  @return the tick length used by this renderer
	 */
	public int getTickLength();

	/**
	 *  Sets the tick length used to indicate the pie segments
	 *  @param tickLength the length of the ticks in pixels
	 */
	public void setTickLength(int tickLength);

	/**
	 *  @return the point labeler, which is responsible for specifying what the labels should say
	 */
	public PointLabeler getPointLabeler();

	/**
	 *  Render the labels to the supplied graphics context
	 *  @param g the graphics context
	 *  @param chart the chart to render
	 *  @param model the model from which the points come
	 *  @param center the center of the pie
	 *  @param width the width of the pie
	 *  @param height the height of the pie
	 *  @param angles the angles to use for the segments of the pie
	 *  @param style the chart style to use for displaying the segments
	 */
	public void renderLabels(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.Point center, int width, int height, int[] angles, com.jidesoft.chart.style.ChartStyle style);
}
