/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface implemented by objects that are responsible for painting the labels of a pie chart, but also
 *  supporting floating point numbers for positioning.
 */
public interface PieLabelRenderer2D extends PieLabelRenderer {

	/**
	 *  Render the labels to the supplied graphics context
	 *  @param g the graphics context
	 *  @param chart the chart to render
	 *  @param model the model from which the points come
	 *  @param center the center of the pie
	 *  @param width the width of the pie
	 *  @param height the height of the pie
	 *  @param angles the angles to use for the segments of the pie
	 *  @param style the chart style to use for displaying the segments
	 */
	public void renderLabels(java.awt.Graphics2D g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel model, java.awt.geom.Point2D center, double width, double height, float[] angles, com.jidesoft.chart.style.ChartStyle style);
}
