/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface implemented by objects responsible for rendering the pie segments of a pie chart.
 */
public interface PieSegmentRenderer {

	/**
	 *  Set the length of the ticks used for each segment
	 *  @param length the length of ticks in pixels
	 */
	public void setTickLength(int length);

	/**
	 *  @return the tick length
	 */
	public int getTickLength();

	/**
	 *  Set the point labeler, which is used to customize the strings displayed as labels
	 *  @param labeler the labeler object
	 */
	public void setPointLabeler(PointLabeler labeler);

	/**
	 *  @return the point labeler
	 */
	public PointLabeler getPointLabeler();

	/**
	 *  Allow the users of the renderer to specify a different graphics context for the pie segment labels
	 *  @param g the graphics context for the pie segment labels
	 */
	public void setLabelGraphics(java.awt.Graphics g);

	/**
	 *  Determines how to render the labels
	 */
	public PieLabelRenderer getPieLabelRenderer();

	/**
	 *  Find the segment containing the supplied point, if any
	 *  @param p the point of interest
	 *  @return a descriptor that indicates which segment, if any, contains the point
	 */
	public com.jidesoft.chart.event.PointDescriptor containingSegment(java.awt.Point p);

	/**
	 *  Clear out the shapes used for rendering the points
	 */
	public void clearShapes();

	/**
	 *  The method for rendering segments onto the supplied graphics context
	 *  @param g the Graphics context
	 *  @param chart the chart
	 *  @param m the model of interest
	 *  @param center the center point (in pixel coordinates) of the rendered area
	 *  @param radius the radius of the pie chart (in pixels)
	 *  @param angles the angles (in degrees) of the respective segments of the model
	 */
	public void renderSegments(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, java.awt.Point center, int radius, int[] angles);
}
