/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface implemented by objects responsible for rendering the pie segments of a pie chart, but also supporting
 *  the use of floating point numbers for the positioning of the segments.
 */
public interface PieSegmentRenderer2D extends PieSegmentRenderer {

	/**
	 *  The method for rendering segments onto the supplied graphics context
	 *  @param g the Graphics2D context
	 *  @param chart the chart
	 *  @param m the model of interest
	 *  @param center the center point (in pixel coordinates) of the rendered area
	 *  @param radius the radius of the pie chart (in pixels)
	 *  @param angles the angles (in degrees) of the respective segments of the model
	 */
	public void renderSegments(java.awt.Graphics2D g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, java.awt.geom.Point2D center, float radius, float[] angles);
}
