/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface for classes that can take a chartable point and generate the text to use for the label
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface PointLabeler {

	/**
	 *  Create the text to use for the label for the supplied point
	 *  @param p the point for which we need some display text for a label
	 *  @return the text
	 */
	public String getDisplayText(com.jidesoft.chart.model.Chartable p);
}
