/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  An interface for classes that can be used to render points in a Chart
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface PointRenderer {

	/**
	 *  Render the point at the given x,y coordinates
	 * 
	 *  @param g     the Graphics context for rendering the point
	 *  @param chart the Chart object
	 *  @param m     the model from which the point derives
	 *  @param point the Chartable object to paint
	 *  @param isSelected whether the point is currently selected
	 *  @param hasRollover whether the point is currently in a rollover state
	 *  @param hasFocus whether the point currently has editing focus
	 *  @param x     the x coordinate (in pixels) for the location of the point
	 *  @param y     the y coordinate (in pixels) for the location of the point
	 *  @return the rendered shape
	 */
	public java.awt.Shape renderPoint(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable point, boolean isSelected, boolean hasRollover, boolean hasFocus, int x, int y);
}
