/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  A Bar Renderer that makes the bar appear to be raised out of the screen like a candy bar.
 *  <p>
 *  This renderer takes account of negative heights. If a negative height is supplied, then the y coordinate and height
 *  are adjusted so that the height becomes positive and the shape is paintable. 
 *  <p>NOTE: Widths are currently assumed to be positive</p>
 */
public class RaisedBarRenderer extends AbstractBarRenderer implements BarRenderer2D {

	public RaisedBarRenderer() {
	}

	/**
	 *  Create a RaisedBarRenderer using the supplied edge size
	 *  @param edgeSize the edge size for the raised effect
	 */
	public RaisedBarRenderer(int edgeSize) {
	}

	/**
	 *  @return the size of the edge effect, in pixels, that gives bars their 'candy bar' appearance 
	 */
	public int getEdgeSize() {
	}

	/**
	 *  Specify the size, in pixels, of the edge effect that gives the raised bars their 'candy bar' appearance.
	 *  By default, this is 20 pixels, but you may want to set it to a smaller value if you have narrow bars.
	 *  @param edgeSize the new edge size
	 */
	public void setEdgeSize(int edgeSize) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public java.awt.Shape renderBar(java.awt.Graphics2D g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable p, boolean isSelected, boolean hasRollover, boolean hasFocus, double x, double y, double width, double height) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public java.awt.Shape renderBar(java.awt.Graphics g, com.jidesoft.chart.Chart chart, com.jidesoft.chart.model.ChartModel m, com.jidesoft.chart.model.Chartable p, boolean isSelected, boolean hasRollover, boolean hasFocus, int x, int y, int width, int height) {
	}

	/**
	 *  Create a Paint to use for the upper half of the top of the bar
	 */
	protected java.awt.Paint createUpperTopPaint(com.jidesoft.chart.Orientation orientation, java.awt.Color color, int x, int y, int width, int edgeSize) {
	}

	/**
	 *  Create a Paint to use for the lower half of the top of the bar
	 */
	protected java.awt.Paint createLowerTopPaint(com.jidesoft.chart.Orientation orientation, java.awt.Color color, int x, int y, int width, int edgeSize) {
	}

	/**
	 *  Create a Paint to use for the bottom part of the bar
	 */
	protected java.awt.Paint createBottomPaint(com.jidesoft.chart.Orientation orientation, java.awt.Color color, int x, int y, int width, int edgeSize) {
	}

	/**
	 *  Create a Paint to use for the left part of the bar
	 */
	protected java.awt.Paint createLeftPaint(com.jidesoft.chart.Orientation orientation, java.awt.Color color, int x, int y, int width, int edgeSize) {
	}

	/**
	 *  Create a Paint to use for the right part of the bar
	 */
	protected java.awt.Paint createRightPaint(com.jidesoft.chart.Orientation orientation, java.awt.Color color, int x, int y, int width, int edgeSize) {
	}

	public int getMinimumBreadth() {
	}
}
