/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  <p>A shadow renderer generates a drop shadow for any given picture, respecting the transparency channel if present.
 *  The resulting picture contains the shadow only and to create a drop shadow effect you will need to stack the original
 *  picture and the shadow generated by the renderer.</p> <h2>Shadow Properties</h2> <p>A shadow is defined by three
 *  properties: <ul> <li><i>size</i>: The size, in pixels, of the shadow. This property also defines the fuzziness.</li>
 *  <li><i>opacity</i>: The opacity, between 0.0 and 1.0, of the shadow.</li> <li><i>color</i>: The color of the shadow.
 *  Shadows are not meant to be black only.</li> </ul> You can set these properties using the provided mutaters or the
 *  appropriate constructor. Here are two ways of creating a green shadow of size 10 and with an opacity of 50%:
 *  <pre>
 *  ShadowRenderer renderer = new ShadowRenderer(10, 0.5f, Color.GREEN);
 *  // ..
 *  renderer = new ShadowRenderer();
 *  renderer.setSize(10);
 *  renderer.setOpacity(0.5f);
 *  renderer.setColor(Color.GREEN);
 *  </pre>
 *  The default constructor provides the following default values: <ul> <li><i>size</i>: 5 pixels</li>
 *  <li><i>opacity</i>: 50%</li> <li><i>color</i>: Black</li> </ul></p> <h2>Generating a Shadow</h2> <p>A shadow is
 *  generated as a <code>BufferedImage</code> from another <code>BufferedImage</code>. Once the renderer is set up, you
 *  must call {@link #createShadow} to actually generate the shadow:
 *  <pre>
 *  ShadowRenderer renderer = new ShadowRenderer();
 *  // renderer setup
 *  BufferedImage shadow = renderer.createShadow(bufferedImage);
 *  </pre></p>
 *  <p>The generated image dimensions are computed as following:</p>
 *  <pre>
 *  width  = imageWidth  + 2 * shadowSize
 *  height = imageHeight + 2 * shadowSize
 *  </pre>
 *  <h2>Properties Changes</h2> <p>This renderer allows to register property change listeners with {@link
 *  #addPropertyChangeListener}. Listening to properties changes is very useful when you embed the renderer in a
 *  graphical component and give the API user the ability to access the renderer. By listening to properties changes, you
 *  can easily repaint the component when needed.</p> <h2>Threading Issues</h2> <p><code>ShadowRenderer</code> is not
 *  guaranteed to be thread-safe.</p>
 * 
 *  @author Romain Guy <romain.guy@mac.com>
 *  @author Sebastien Petrucci
 * 
 *  @deprecated in favour of com.jidesoft.swing
 */
public class ShadowFactory {

	/**
	 *  <p>Identifies a change to the size used to render the shadow.</p> <p>When the property change event is fired, the
	 *  old value and the new value are provided as <code>Integer</code> instances.</p>
	 */
	public static final String PROPERTY_SHADOW_SIZE = "shadowSize";

	/**
	 *  <p>Identifies a change to the opacity used to render the shadow.</p> <p>When the property change event is fired,
	 *  the old value and the new value are provided as <code>Float</code> instances.</p>
	 */
	public static final String PROPERTY_SHADOW_OPACITY = "shadowOpacity";

	/**
	 *  <p>Identifies a change to the color used to render the shadow.</p>
	 */
	public static final String PROPERTY_SHADOW_COLOR = "shadowColor";

	/**
	 *  <p>Creates a default good looking shadow generator. The default shadow renderer provides the following default
	 *  values: <ul> <li><i>size</i>: 5 pixels</li> <li><i>opacity</i>: 50%</li> <li><i>color</i>: Black</li> </ul></p>
	 *  <p>These properties provide a regular, good looking shadow.</p>
	 */
	public ShadowFactory() {
	}

	/**
	 *  <p>A shadow renderer needs three properties to generate shadows. These properties are:</p> <ul> <li><i>size</i>:
	 *  The size, in pixels, of the shadow. This property also defines the fuzziness.</li> <li><i>opacity</i>: The
	 *  opacity, between 0.0 and 1.0, of the shadow.</li> <li><i>color</i>: The color of the shadow. Shadows are not
	 *  meant to be black only.</li> </ul>
	 * 
	 *  @param size    the size of the shadow in pixels. Defines the fuzziness.
	 *  @param opacity the opacity of the shadow.
	 *  @param color   the color of the shadow.
	 */
	public ShadowFactory(int size, float opacity, java.awt.Color color) {
	}

	/**
	 *  <p>Add a PropertyChangeListener to the listener list. The listener is registered for all properties. The same
	 *  listener object may be added more than once, and will be called as many times as it is added. If
	 *  <code>listener</code> is null, no exception is thrown and no action is taken.</p>
	 * 
	 *  @param listener the PropertyChangeListener to be added
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  <p>Remove a PropertyChangeListener from the listener list. This removes a PropertyChangeListener that was
	 *  registered for all properties. If <code>listener</code> was added more than once to the same event source, it
	 *  will be notified one less time after being removed. If <code>listener</code> is null, or was never added, no
	 *  exception is thrown and no action is taken.</p>
	 * 
	 *  @param listener the PropertyChangeListener to be removed
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  <p>Gets the color used by the renderer to generate shadows.</p>
	 * 
	 *  @return this renderer's shadow color
	 */
	public java.awt.Color getColor() {
	}

	/**
	 *  <p>Sets the color used by the renderer to generate shadows.</p> <p>Consecutive calls to {@link #createShadow}
	 *  will all use this color until it is set again.</p> <p>If the color provided is null, the previous color will be
	 *  retained.</p>
	 * 
	 *  @param shadowColor the generated shadows color
	 */
	public void setColor(java.awt.Color shadowColor) {
	}

	/**
	 *  <p>Gets the opacity used by the renderer to generate shadows.</p> <p>The opacity is comprised between 0.0f and
	 *  1.0f; 0.0f being fully transparent and 1.0f fully opaque.</p>
	 * 
	 *  @return this renderer's shadow opacity
	 */
	public float getOpacity() {
	}

	/**
	 *  <p>Sets the opacity used by the renderer to generate shadows.</p> <p>Consecutive calls to {@link #createShadow}
	 *  will all use this opacity until it is set again.</p> <p>The opacity is comprised between 0.0f and 1.0f; 0.0f
	 *  being fully transparent and 1.0f fully opaque. If you provide a value out of these boundaries, it will be
	 *  restrained to the closest boundary.</p>
	 * 
	 *  @param shadowOpacity the generated shadows opacity
	 */
	public void setOpacity(float shadowOpacity) {
	}

	/**
	 *  <p>Gets the size in pixel used by the renderer to generate shadows.</p>
	 * 
	 *  @return this renderer's shadow size
	 */
	public int getSize() {
	}

	/**
	 *  <p>Sets the size, in pixels, used by the renderer to generate shadows.</p> <p>The size defines the blur radius
	 *  applied to the shadow to create the fuzziness.</p> <p>There is virtually no limit to the size. The size cannot be
	 *  negative. If you provide a negative value, the size will be 0 instead.</p>
	 * 
	 *  @param shadowSize the generated shadows size in pixels (fuzziness)
	 */
	public void setSize(int shadowSize) {
	}

	/**
	 *  <p>Generates the shadow for a given picture and the current properties of the renderer.</p> <p>The generated
	 *  image dimensions are computed as following:</p>
	 *  <pre>
	 *  width  = imageWidth  + 2 * shadowSize
	 *  height = imageHeight + 2 * shadowSize
	 *  </pre>
	 * 
	 *  @param image the picture from which the shadow must be cast
	 *  @return the picture containing the shadow of <code>image</code>
	 */
	public java.awt.image.BufferedImage createShadow(java.awt.image.BufferedImage image) {
	}
}
