/**
 *  Package containing renderers used by Chart, such as point renderers and line renderers.
 */
package com.jidesoft.chart.render;


/**
 *  A renderer for drawing lines smoothly on a chart. Rather than rendering a line by drawing straight line
 *  segments to join the points of a ChartModel (like the DefaultLineRenderer), this class uses Bezier
 *  curves to join the points.
 */
public class SmoothLineRenderer extends AbstractLineRenderer implements LineRenderer2D {

	public static final String PROPERTY_CHART = "Chart";

	public static final String PROPERTY_SMOOTHNESS = "Smoothness";

	/**
	 *  Creates a DefaultLineRenderer using the supplied chart object as the chart object onto which
	 *  lines should be drawn.
	 * 
	 *  @param chart the chart object
	 */
	public SmoothLineRenderer(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Returns the chart associated with this renderer
	 * 
	 *  @return the chart object associated with this renderer
	 */
	public com.jidesoft.chart.Chart getChart() {
	}

	/**
	 *  <p>Sets the chart onto which the lines should be drawn.</p>
	 *  <p><b>Note:</b> The chart property is implemented as a weak reference so that it will be garbage collected
	 *  when it is no longer needed. This saves you from having to call setChart(null) on this object when you have
	 *  finished with the renderer.</p>
	 * 
	 *  @param chart the Chart object
	 */
	public void setChart(com.jidesoft.chart.Chart chart) {
	}

	/**
	 *  Returns the smoothness factor used in generating a curve between points
	 * 
	 *  @return the smoothness factor used in generating a curve between points
	 */
	public double getSmoothness() {
	}

	/**
	 *  Specify the smoothness to use in generating a curve to join points.
	 * 
	 *  @param smoothness the smoothness factor used in generating a curve between points
	 */
	public void setSmoothness(double smoothness) {
	}

	/**
	 *  Adds a property change listener to this object
	 * 
	 *  @param listener a property change listener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove the supplied property change listener from this object
	 * 
	 *  @param listener the property change listener to remove
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  {@inheritDoc}
	 */
	@java.lang.SuppressWarnings("cast")
	public java.awt.Shape renderLine(java.awt.Graphics2D g2d, com.jidesoft.chart.model.ChartModel m, double[] xPoints, double[] yPoints, com.jidesoft.chart.style.ChartStyle style) {
	}

	public java.awt.Shape renderLine(java.awt.Graphics g, com.jidesoft.chart.model.ChartModel m, int[] xPoints, int[] yPoints, com.jidesoft.chart.style.ChartStyle style) {
	}
}
