/**
 *  This package contains classes to support the dynamic generation of charts to serve up from a web server.
 *  It is currently experimental and subject to change.
 */
package com.jidesoft.chart.servlet;


/**
 *  <p>The base URL causes a chart servlet to be called and the chart servlet delegates control to this class to create a
 *  suitable chart object from the URL and its parameters. The base URL might be something like:<br>
 *  <pre>http://localhost:8080/Charts/chart?</pre>
 *  <p>After that, there follows a series of key-value pairs, where each key is expected to use a particular syntax for
 *  the information that it provides. A lot of information needs to be packed into a small number of characters, but 
 *  it's not as bad as it sounds and it should be possible to start generating charts from the servlet within the 
 *  space of a few minutes.</p> 
 *  <p>The parameters are as follows:</p>
 *  <dl>
 *  <dt>size</dt>
 *  <dd>The width and height of the chart in pixels. For example, for a chart 600 pixels wide and 400 pixels high, use
 *      <pre>size=600x400</pre>
 *  </dd>
 *  <dt>axes</dt>
 *  <dd>A list of semi-colon separated axes and their ranges</dd>
 *  <dt>xyd</dt>
 *  <dd>A list of XY points. The x and y points of a pair are separated by a comma and the pairs are separated by a 
 *  semi-colon. The whole list is enclosed in brackets []. </dd>
 *  </dl>
 */
public class DefaultHttpChartFactory implements HttpComponentFactory {

	/**
	 *  Default Constructor
	 */
	public DefaultHttpChartFactory() {
	}

	/**
	 *  The main factory method
	 */
	public com.jidesoft.chart.Chart getInstance(HttpServletRequest request) {
	}
}
