/**
 *  This package contains classes to support the dynamic generation of charts to serve up from a web server.
 *  It is currently experimental and subject to change.
 */
package com.jidesoft.chart.servlet;


/**
 *  Here, we define a factory interface that returns a Component in response to
 *  an HTTP Request. This means we can have a general server-side mechanism that
 *  generates custom components on demand. 
 */
public interface HttpComponentFactory {

	/**
	 *  Create and return an instance of the component in response to an HTTP
	 *  request.
	 *  
	 *  @param request
	 *             the HTTP request
	 *  @return an instance of a Component
	 */
	public java.awt.Component getInstance(HttpServletRequest request);
}
