/**
 *  A packaging for providing presentation styles for Chart traces/models.
 */
package com.jidesoft.chart.style;


/**
 *  An abstract superclass for all styles used in Chart charts; for example LineStyles and ChartStyles. Styling is used
 *  to change the appearance of chart points and other chart annotations.
 * 
 *  @see LineStyle
 *  @see ChartStyle
 */
public abstract class AbstractStyle {

	/**
	 *  Default constructor
	 */
	public AbstractStyle() {
	}

	public AbstractStyle(java.awt.Color color) {
	}

	/**
	 *  Returns the paint property as a Color object. If the paint property is not an instance of Color, null is returned.
	 * 
	 *  @return the color to use for styling
	 */
	@javax.xml.bind.annotation.XmlAttribute
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlColorAdapter.class)
	public java.awt.Color getColor() {
	}

	/**
	 *  Specify the color to use when rendering
	 * 
	 *  @param color the color to use when rendering
	 */
	public void setColor(java.awt.Color color) {
	}

	/**
	 *  Specify the paint to use when rendering
	 * 
	 *  @param paint the paint to use when rendering
	 */
	public void setPaint(java.awt.Paint paint) {
	}

	/**
	 *  Returns the paint used
	 * 
	 *  @return the paint
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.Paint getPaint() {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}
}
