/**
 *  A packaging for providing presentation styles for Chart traces/models.
 */
package com.jidesoft.chart.style;


/**
 *  Contains style information for a point by combining PointStyle, LineStyle and BarStyle.
 */
public class ChartStyle {

	public static final ChartStyle DEFAULT_STYLE;

	/**
	 *  Create a default ChartStyle
	 */
	public ChartStyle() {
	}

	/**
	 *  Copy constructor for a ChartStyle
	 *  @param style the chart style object to copy
	 */
	public ChartStyle(ChartStyle style) {
	}

	/**
	 *  Constructs a style for showing the lines only
	 * 
	 *  @param color the color to use for the lines
	 */
	public ChartStyle(java.awt.Color color) {
	}

	/**
	 *  Constructs a style for showing the points only
	 * 
	 *  @param pointColor the color to use for the points
	 *  @param shape the shape to use for the points
	 */
	public ChartStyle(java.awt.Color pointColor, com.jidesoft.chart.PointShape shape) {
	}

	/**
	 *  Constructs a style for showing the points only
	 * 
	 *  @param pointColor the color to use for the points
	 *  @param shape the shape to use for the points
	 *  @param pointSize the size of the points
	 */
	public ChartStyle(java.awt.Color pointColor, com.jidesoft.chart.PointShape shape, int pointSize) {
	}

	/**
	 *  Constructs a style for showing lines and/or points of the same color
	 * 
	 *  @param color the color to use for points, lines and bars as appropriate
	 *  @param pointsVisible whether points should be visible
	 *  @param linesVisible whether lines should be visible
	 */
	public ChartStyle(java.awt.Color color, boolean pointsVisible, boolean linesVisible) {
	}

	/**
	 *  Constructs a style for showing lines, points and bars of the same color
	 * 
	 *  @param color the color to use for points, lines and bars as appropriate
	 *  @param pointsVisible whether points should be visible
	 *  @param linesVisible whether lines should be visible
	 *  @param barsVisible whether bars should be visible
	 */
	public ChartStyle(java.awt.Color color, boolean pointsVisible, boolean linesVisible, boolean barsVisible) {
	}

	/**
	 *  Constructs a style for showing lines and points with specified colors
	 * 
	 *  @param pointColor the color to use for points
	 *  @param shape the (suggested) shape to use for points
	 *  @param lineColor the color to use for lines
	 */
	public ChartStyle(java.awt.Color pointColor, com.jidesoft.chart.PointShape shape, java.awt.Color lineColor) {
	}

	/**
	 *  A chaining style method that specifies that we want to use points only
	 *  @return this ChartStyle instance
	 */
	public ChartStyle withPoints() {
	}

	/**
	 *  A chaining style method that specifies that we want to use lines only
	 *  @return this ChartStyle instance
	 */
	public ChartStyle withLines() {
	}

	/**
	 *  A chaining style method that specifies to use lines, but also using the supplied line fill.
	 *  This effectively creates an Area chart.
	 *  @return this ChartStyle instance
	 */
	public ChartStyle withLineFill(java.awt.Paint lineFill) {
	}

	/**
	 *  A chaining style method that specifies that we want to display none of points, lines or bars. 
	 *  Useful when using a highlight to mark a point as a discontinuity in the model.
	 *  @return this ChartStyle instance
	 */
	public ChartStyle withNothing() {
	}

	/**
	 *  A chaining style method that specifies that we want to use bars only
	 *  @return this ChartStyle instance
	 */
	public ChartStyle withBars() {
	}

	/**
	 *  A chaining style method that specifies that we want to use bars only, and also
	 *  allows you to specify the fill for the bars
	 *  @return this ChartStyle instance
	 */
	public ChartStyle withBars(java.awt.Paint barPaint) {
	}

	/**
	 *  A chaining style method that specifies that we want to use points and lines
	 *  @return this ChartStyle instance
	 */
	public ChartStyle withPointsAndLines() {
	}

	/**
	 *  Returns the color to use when rendering points
	 *  @return the Color used for painting points for any model to which this style is applied
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.Color getPointColor() {
	}

	/**
	 *  Set the Color used for painting points
	 *  @param color the color to use for the points
	 */
	public void setPointColor(java.awt.Color color) {
	}

	/**
	 *  Returns the currently specified point size
	 *  @return the size of points used according to this style (in pixels)
	 */
	@javax.xml.bind.annotation.XmlTransient
	public int getPointSize() {
	}

	/**
	 *  Set the size of points (in pixels)
	 *  @param newSize the new size
	 */
	public void setPointSize(int newSize) {
	}

	/**
	 *  Returns the current shape of points
	 *  @return the shape of points, as defined by the PointShape enum
	 */
	@javax.xml.bind.annotation.XmlTransient
	public com.jidesoft.chart.PointShape getPointShape() {
	}

	/**
	 *  Set the shape of points used by this style 
	 *  @param newShape the new shape of points
	 */
	public void setPointShape(com.jidesoft.chart.PointShape newShape) {
	}

	/**
	 *  Returns the currently specified line color
	 *  @return the color of lines used in this style
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.Color getLineColor() {
	}

	/**
	 *  Sets the color of lines used in this style
	 *  @param lineColor the new line color
	 */
	public void setLineColor(java.awt.Color lineColor) {
	}

	/**
	 *  Returns whether lines are currently visible
	 *  @return whether lines are visible in this style
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public boolean isLinesVisible() {
	}

	/**
	 *  Sets the visibility of lines in this style
	 *  @param linesVisible whether lines should be visible
	 */
	public void setLinesVisible(boolean linesVisible) {
	}

	/**
	 *  Returns whether points are currently visible
	 *  @return whether points are visible in this style
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public boolean isPointsVisible() {
	}

	/**
	 *  Determine whether points are visible in this style
	 *  @param pointsVisible specifies whether points should be rendered for this style
	 */
	public void setPointsVisible(boolean pointsVisible) {
	}

	/**
	 *  This has been deprecated and will be removed sometime after 2.10
	 *  @deprecated in favour of isBarsVisible
	 *  @return whether bars are visible in this style
	 */
	@javax.xml.bind.annotation.XmlTransient
	public boolean isBarVisible() {
	}

	/**
	 *  Returns whether bars are visible in this style
	 *  @return whether bars are visible in this style
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public boolean isBarsVisible() {
	}

	/**
	 *  Note that this method will be removed some time after version 2.9.4
	 *  @deprecated please use <code>setBarsVisible()</code> instead
	 *  @param visible whether bars should be visible
	 */
	public void setBarVisible(boolean visible) {
	}

	/**
	 *  Specify whether bars are visible in this style (that is, the bars of a bar chart)
	 *  @param visible state whether bars should be rendered
	 */
	public void setBarsVisible(boolean visible) {
	}

	/**
	 *  Returns the color of bars for this style
	 *  @return the color of bars for this style
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.Color getBarColor() {
	}

	/**
	 *  Returns the paint used for rendering bars or filling the segments of a pie chart
	 *  @return the paint used for rendering bars
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.Paint getBarPaint() {
	}

	/**
	 *  Specify the bar color for rendering bars
	 *  @param color the new color
	 */
	public void setBarColor(java.awt.Color color) {
	}

	/**
	 *  Specify the bar paint for rendering bars or filling the segments of a pie chart
	 *  @param paint the paint to use when rendering bars
	 */
	public void setBarPaint(java.awt.Paint paint) {
	}

	/**
	 *  Returns the preferred width of bars according to this style
	 *  @return the preferred width of bars according to this style. This might not be used depending on other layout
	 *  factors.
	 */
	public Integer getBarWidth() {
	}

	/**
	 *  Specify the width of bars
	 *  @param barWidth the width of bars in pixels
	 */
	public void setBarWidth(Integer barWidth) {
	}

	public Double getBarWidthProportion() {
	}

	public void setBarWidthProportion(Double barWidthProportion) {
	}

	/**
	 *  This method is deprecated and will be removed some time after release 2.10
	 *  @return the shape of points
	 *  @deprecated in favour of <code>getPointShape()</code> 
	 */
	@javax.xml.bind.annotation.XmlTransient
	public com.jidesoft.chart.PointShape getShape() {
	}

	/**
	 *  Sets the shape to use for rendering points. The shape <i>may</i> be overridden by a custom renderer.
	 *  @param shape the shape to use
	 *  @deprecated in favour of <code>setPointShape()</code>
	 */
	public void setShape(com.jidesoft.chart.PointShape shape) {
	}

	/**
	 *  Returns the style to use when rendering lines
	 *  @return the style to use when rendering lines
	 */
	public LineStyle getLineStyle() {
	}

	/**
	 *  Specify the style to use when rendering lines
	 *  @param lineStyle the new line style
	 */
	public void setLineStyle(LineStyle lineStyle) {
	}

	/**
	 *  Returns the style to use for rendering the bars of a bar chart
	 *  @return the style to use for rendering the bars of a bar chart
	 */
	public BarStyle getBarStyle() {
	}

	/**
	 *  Set the style to use when rendering the bars of a bar chart
	 *  @param barStyle the style to use for the rendering of bars
	 */
	public void setBarStyle(BarStyle barStyle) {
	}

	/**
	 *  The paint to use in area charts when filling from the line to the axis
	 *  @return the paint
	 *  @deprecated in favour of getLineFill()
	 *  Note that this method will be removed some time after release 2.10
	 */
	public java.awt.Paint getLinePaint() {
	}

	/**
	 *  The paint to use in area charts when filling from the line to the axis
	 *  @return the paint
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.Paint getLineFill() {
	}

	/**
	 *  Specify the paint to use in area charts when filling from the line to the axis
	 *  @param fill the paint to use
	 */
	public void setLineFill(java.awt.Paint fill) {
	}

	public com.jidesoft.chart.Orientation getLineFillOrientation() {
	}

	public void setLineFillOrientation(com.jidesoft.chart.Orientation orientation) {
	}

	public LineFillExtent getLineFillExtent() {
	}

	public void setLineFillExtent(LineFillExtent extent) {
	}

	/**
	 *  Returns the width of lines according to the style
	 *  @return the width of lines
	 */
	@javax.xml.bind.annotation.XmlTransient
	public int getLineWidth() {
	}

	/**
	 *  Set the width of lines
	 *  @param width the width in pixels
	 */
	public void setLineWidth(int width) {
	}

	/**
	 *  Set the stroke to use for lines
	 *  @param stroke the stroke to use for lines
	 */
	public void setLineStroke(java.awt.BasicStroke stroke) {
	}

	/**
	 *  Returns the current stroke used for lines
	 *  @return the current Stroke used when rendering lines
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.BasicStroke getLineStroke() {
	}

	/**
	 *  Returns the style used for rendering points
	 *  @return the style used for rendering points
	 */
	public PointStyle getPointStyle() {
	}

	/**
	 *  Specify the style to use when rendering points
	 *  @param pointStyle the new point style
	 */
	public void setPointStyle(PointStyle pointStyle) {
	}

	/**
	 *  Returns the current orientation of the bars
	 *  @return the orientation of bars when drawing bar charts
	 */
	@javax.xml.bind.annotation.XmlTransient
	public com.jidesoft.chart.Orientation getBarOrientation() {
	}

	/**
	 *  Specify the orientation of bars when drawing bar charts
	 *  @param orientation the orientation of the bars (horizontal or vertical)
	 */
	public void setBarOrientation(com.jidesoft.chart.Orientation orientation) {
	}

	/**
	 *  Returns the angular offset of the pie chart in degrees
	 *  @return the angular offset of the pie chart in degrees
	 */
	public float getPieOffsetAngle() {
	}

	/**
	 *  Specifies the angular offset of the pie chart in degrees
	 *  @param offsetAngle the angular offset of the pie chart in degrees
	 */
	public void setPieOffsetAngle(float offsetAngle) {
	}

	/**
	 *  Returns the amount by which exploded segments are displaced when selected
	 *  @return the amount by which exploded segments are displaced, as a proportion of the radius of the pie chart
	 */
	public float getPieExplosionRatio() {
	}

	/**
	 *  Specifies the amount by which exploded segments are displaced when selected
	 *  @param explosionRatio the amount by which exploded segments are displaced when selected
	 */
	public void setPieExplosionRatio(float explosionRatio) {
	}

	/**
	 *  Specify whether pie segments should always be exploded, regardless of selection
	 *  @param alwaysExploded whether to explode segments regardless of selection
	 */
	public void setPieSegmentsAlwaysExploded(boolean alwaysExploded) {
	}

	/**
	 *  Returns a boolean to indicate whether pie segments are exploded, regardless of selection
	 *  @return a boolean to indicate whether pie segments are exploded regardless of selection
	 */
	public boolean isPieSegmentsAlwaysExploded() {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
