/**
 *  A packaging for providing presentation styles for Chart traces/models.
 */
package com.jidesoft.chart.style;


/**
 *  The style for a line of the chart
 */
public class LineStyle extends AbstractStyle {

	/**
	 *  The default width is 1 pixel.
	 */
	public static final int DEFAULT_WIDTH = 1;

	/**
	 *  The default stroke is a solid line of default width, with CAP_SQUARE and JOIN_BEVEL
	 */
	public static final java.awt.BasicStroke DEFAULT_STROKE;

	/**
	 *  Create a Line Style using a default stroke and default width.
	 */
	public LineStyle() {
	}

	/**
	 *  Create a Line Style using a default stroke and the supplied width.
	 *  @param width the width of the lines
	 */
	public LineStyle(int width) {
	}

	/**
	 *  Create a Line Style using the supplied stroke
	 *  @param stroke the stroke to use for styling the lines
	 */
	public LineStyle(java.awt.BasicStroke stroke) {
	}

	/**
	 *  Create a line style using the supplied color and width
	 *  @param color the color of the line
	 *  @param width the width of the line in pixels
	 */
	public LineStyle(java.awt.Color color, int width) {
	}

	/**
	 *  Create a line style using the supplied color, width and stroke settings
	 *  @param color the color of the line
	 *  @param stroke the stroke to use for painting the line
	 */
	public LineStyle(java.awt.Color color, java.awt.BasicStroke stroke) {
	}

	/**
	 *  @return the currently used fill paint
	 */
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlPaintAdapter.class)
	public java.awt.Paint getFill() {
	}

	/**
	 *  When set, this specifies a fill to use between the line of the model and the x axis.
	 * 
	 *  @param fill a paint - often a GradientPaint
	 */
	public void setFill(java.awt.Paint fill) {
	}

	public void setFillOrientation(com.jidesoft.chart.Orientation fillOrientation) {
	}

	public com.jidesoft.chart.Orientation getFillOrientation() {
	}

	/**
	 *  Returns the boundary to which the line is filled (if a fill is applied)
	 *  @return the boundary to which the line is filled
	 */
	public LineFillExtent getFillExtent() {
	}

	/**
	 *  Specify which boundary to fill the line to; by default fills to zero on the axis indicated by the choice
	 *  of fill orientation
	 *  @param fillExtent the boundary to fill the line to
	 */
	public void setFillExtent(LineFillExtent fillExtent) {
	}

	/**
	 *  Specify the width to use for the lines
	 *  @param width the new width of the lines
	 */
	public void setWidth(int width) {
	}

	/**
	 *  Returns the currently specified width of the lines
	 *  @return the width of the lines in pixels
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public int getWidth() {
	}

	/**
	 *  Returns the stroke of the lines
	 *  @return the stroke of the lines
	 */
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlBasicStrokeAdapter.class)
	public java.awt.BasicStroke getStroke() {
	}

	/**
	 *  Specify the stroke of the lines
	 *  @param stroke the new stroke to use for the lines
	 */
	public void setStroke(java.awt.BasicStroke stroke) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
