/**
 *  A packaging for providing presentation styles for Chart traces/models.
 */
package com.jidesoft.chart.style;


public class PieStyle {

	public PieStyle() {
	}

	/**
	 *  Returns the offset angle used when drawing a pie chart
	 *  @return the offset angle (in degrees)
	 */
	public float getOffsetAngle() {
	}

	/**
	 *  Specify the offset angle to use when drawing a pie chart.
	 *  By default this is 0, which means that angles are measured from a line pointing pointing east and
	 *  are subtended anti-clockwise. Opening animations are measured from this angle, and provided there is
	 *  more than one segment in the pie chart, this angle will always be the dividing line between two segments.
	 *  @param offsetAngle the offset angle (in degrees)
	 */
	public void setOffsetAngle(float offsetAngle) {
	}

	/**
	 *  Returns the amount by which pie segments are moved when selected and the exploded segments effect is in use.
	 *  @return the amount by which segments are displaced as a ratio of the radius of the pie
	 */
	public float getExplosionRatio() {
	}

	/**
	 *  Specifies the amount that a selected pie segment will be 'exploded' out from the rest of the pie chart
	 *  when selected and when the exploded segments effect is active. The amount is specified in terms of the
	 *  radius of the pie chart.
	 *  @param explosionRatio the amount by which pie segments are displaced ('exploded') from the rest of the pie
	 */
	public void setExplosionRatio(float explosionRatio) {
	}

	/**
	 *  Returns whether segments are always displayed in their exploded form
	 *  @return a boolean to indicate whether segments are always exploded
	 */
	public boolean isAlwaysExplodeSegments() {
	}

	/**
	 *  When true, specify that segments should always be displayed in their exploded form,
	 *  even when not selected
	 *  @param alwaysExplodeSegments whether to display segments in their exploded form (regardless of selection)
	 */
	public void setAlwaysExplodeSegments(boolean alwaysExplodeSegments) {
	}
}
