/**
 *  A packaging for providing presentation styles for Chart traces/models.
 */
package com.jidesoft.chart.style;


/**
 *  The style for a point of the chart
 */
public class PointStyle extends AbstractStyle {

	/**
	 *  The default size is 5 pixels.
	 */
	public static final int DEFAULT_SIZE = 5;

	/**
	 *  The default shape is PointShape.DISC
	 */
	public static final com.jidesoft.chart.PointShape DEFAULT_SHAPE;

	/**
	 *  Create a Point Style using default shape (DISC) and size (5 pixels)
	 */
	public PointStyle() {
	}

	/**
	 *  Create a Point Style using the supplied color and default shape and size
	 *  @param color the suggested color to use when rendering the points (the renderer may override this suggestion)
	 */
	public PointStyle(java.awt.Color color) {
	}

	/**
	 *  Create a Point Style using the supplied color and shape, and using a default size
	 *  @param color the suggested color to use for rendering the points
	 *  @param shape the suggested shape to use for rendering the points
	 */
	public PointStyle(java.awt.Color color, com.jidesoft.chart.PointShape shape) {
	}

	/**
	 *  Create a Point Style using the supplied color, shape and size
	 *  @param color the suggested color to use for rendering the points
	 *  @param shape the suggested shape to use for rendering the points
	 *  @param size the size of the points
	 */
	public PointStyle(java.awt.Color color, com.jidesoft.chart.PointShape shape, int size) {
	}

	/**
	 *  Returns the shape of the points
	 *  @return the shape of the points
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public com.jidesoft.chart.PointShape getShape() {
	}

	/**
	 *  Specify the shape of the points
	 *  @param shape the new shape of the points
	 */
	public void setShape(com.jidesoft.chart.PointShape shape) {
	}

	/**
	 *  Returns the size of the points
	 *  @return the size of the points
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public int getSize() {
	}

	/**
	 *  Specify the size of the points
	 *  @param size the new size of the points
	 */
	public void setSize(int size) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
