/**
 *  A packaging for providing presentation styles for Chart traces/models.
 */
package com.jidesoft.chart.style;


/**
 *  <p>StripePaint is a class for creating striped patterns. These patterns can be used for filling other shapes;
 *  in particular, they are excellent for filling the bars of a bar chart.</p>
 *  <p>The basic idea is that you create a stripe by specifying an angle for a line (either as an int for degrees or as
 *  a double for radians), along with the size of the tile in the repeated pattern. The class then constructs the tile
 *  that is used in the <code>Paint</code> fill. You can specify the foreground color for the line and the
 *  background color for the rest of the tile. You can also specify a Stroke to use for the line to give a dotted stripe
 *  effect.</p>
 *  <p>
 *  For more complex patterns you can use a Paint as the background of the tile instead of a <code>Color</code>. This
 *  means you can use a StripePaint as the background to a StripePaint and build up a layered stripe pattern. By careful
 *  use of this feature you can create zig-zag patterns, cross-hatches, crosses, and multi-coloured stripes. Finally, you
 *  can also create a polka-dot paint effect by setting the dashes of your BasicStroke to have a length of zero and a
 *  round cap. The diameter of the dots is the same as the line width. This too, can be used as part of a layered effect -
 *  in the example below the background polka-dot layer has larger dots than the foreground layer, allowing us to create
 *  a polka-dot effect with concentric circles.
 *  </p>
 *  <p>Here are some sample paint patterns generated using StripePaint:</p>
 *  <img src="doc-files/StripePaint-1.png"/>
 *  <p>The number labels on the patterns indicate which of the code fragments from the table (below) can be used to
 *  generate it:</p>
 *  <table border="0" cellspacing="10">
 *  <thead>
 *  <th align="center">Pattern</th>
 *  <th>Code to Generate It</th>
 *  </thead>
 *  <tbody>
 *  <tr>
 *  <td align="center">1</td>
 *  <td style="background:#eee">new StripePaint(0, 10, 2f)</td>
 *  </tr>
 *  <tr>
 *  <td align="center">2</td>
 *  <td style="background:#eee">
 *  StripePaint paint = new StripePaint(-45, 20, 2f);<br>
 *  paint.setForeground(Color.green.darker());
 *  </td>
 *  </tr>
 *  <tr>
 *  <td align="center">3</td>
 *  <td style="background:#eee">
 *  StripePaint paint = new StripePaint(20, 20, 1f);<br>
 *  paint.setForeground(Color.blue);
 *  </td>
 *  </tr>
 *  <tr>
 *  <td align="center">4</td>
 *  <td style="background:#eee">
 *  StripePaint paint = new StripePaint(90, 10, 2f);<br>
 *  paint.setBackground(Color.yellow);<br>
 *  paint.setForeground(Color.red);</td>
 *  </tr>
 *  <tr>
 *  <td align="center">5</td>
 *  <td style="background:#eee">
 *  StripePaint background = new StripePaint(0, 10, 2f);<br>
 *  StripePaint paint = new StripePaint(90, 10, 2f);<br>
 *  paint.setBackground(background);
 *  </td>
 *  </tr>
 *  <tr>
 *  <td align="center">6</td>
 *  <td style="background:#eee">
 *  StripePaint background = new StripePaint(-45, 20, 2f);<br>
 *  background.setForeground(Color.green.darker());<br>
 *  StripePaint paint = new StripePaint(45, 20, 2f);<br>
 *  paint.setBackground(background);<br>
 *  paint.setForeground(Color.green.darker());
 *  </td>
 *  </tr>
 *  <tr>
 *  <td align="center">7</td>
 *  <td style="background:#eee">
 *  new StripePaint(45, 20, new BasicStroke(2f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER, 10f, new float[] {10f, 10f}, 0f));
 *  </td>
 *  </tr>
 *  <tr>
 *  <td align="center">8</td>
 *  <td style="background:#eee">
 *  StripePaint background = new StripePaint(45, 20, new BasicStroke(2f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER, 10f, new float[] {10f, 10f}, 0f));<br>
 *  StripePaint paint = new StripePaint(-45, 20, new BasicStroke(2f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER, 10f, new float[] {10f, 10f}, 10f));<br>
 *  paint.setBackground(background);
 *  </td>
 *  </tr>
 *  <tr>
 *  <td align="center">9</td>
 *  <td style="background:#eee">
 *  StripePaint background = new StripePaint(45, 20, new BasicStroke(2f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER, 10f, new float[] {10f, 10f}, 0f));<br>
 *  StripePaint paint = new StripePaint(-45, 20, new BasicStroke(2f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER, 10f, new float[] {10f, 10f}, 0f));<br>
 *  paint.setBackground(background);</td>
 *  </tr>
 *  <tr>
 *  <td align="center">10</td>
 *  <td style="background:#eee">
 *  StripePaint background = new StripePaint(45, 20, new BasicStroke(2f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER, 10f, new float[] {10f, 10f}, 5f));<br>
 *  StripePaint paint = new StripePaint(-45, 20, new BasicStroke(2f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER, 10f, new float[] {10f, 10f}, 5f));<br>
 *  paint.setBackground(background);</td>
 *  </tr>
 *  <tr>
 *  <td align="center">11</td>
 *  <td style="background:#eee">
 *  StripePaint background = new StripePaint(30, 20, 6f);<br>
 *  background.setForeground(Color.blue);<br>
 *  StripePaint paint = new StripePaint(30, 20, 3f);<br>
 *  paint.setBackground(background);<br>
 *  paint.setForeground(Color.red);
 *  </td>
 *  </tr>
 *  <tr>
 *  <td align="center">12</td>
 *  <td style="background:#eee">
 *  StripePaint background = new StripePaint(45, 30, new BasicStroke(6f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 5f, new float[] {0f, 30f}, 15f));<br>
 *  background.setForeground(Color.blue);<br>
 *  StripePaint paint = new StripePaint(45, 30, new BasicStroke(3f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 5f, new float[] {0f, 30f}, 15f));<br>
 *  paint.setForeground(Color.red);<br>
 *  paint.setBackground(background);
 *  </td>
 *  </tr>
 *  </tbody>
 *  </table>
 * 
 *  @author Simon White
 */
public class StripePaint implements java.awt.Paint {

	/**
	 *  Creates a stripe paint that can be used to fill shapes
	 * 
	 *  @param angleRadians  the angle in radians of the line of the stripe
	 *  @param segmentLength the length of the line segment, used to calculate the size of the paint tile and therefore
	 *                       also the separation between the stripes
	 */
	public StripePaint(double angleRadians, int segmentLength) {
	}

	/**
	 *  Creates a stripe paint that can be used to fill shapes
	 * 
	 *  @param angleDegrees  the angle in degrees of the line of the stripe
	 *  @param segmentLength the length of the line segment, used to calculate the size of the paint tile
	 */
	public StripePaint(int angleDegrees, int segmentLength) {
	}

	/**
	 *  Creates a stripe paint that can be used to fill shapes
	 * 
	 *  @param angleDegrees  the angle in degrees of the line of the stripe
	 *  @param segmentLength the length of the line segment, used to calculate the size of the paint tile
	 *  @param lineWidth     the width of the line
	 */
	public StripePaint(int angleDegrees, int segmentLength, float lineWidth) {
	}

	/**
	 *  Creates a stripe paint that can be used to fill shapes
	 * 
	 *  @param angleRadians  the angle in radians of the line of the stripe
	 *  @param segmentLength the length of the line segment, used to calculate the size of the paint tile
	 *  @param lineWidth     the width of the line
	 */
	public StripePaint(double angleRadians, int segmentLength, float lineWidth) {
	}

	/**
	 *  Creates a stripe paint that can be used to fill shapes
	 * 
	 *  @param angleDegrees  the angle in degrees of the line of the stripe
	 *  @param segmentLength the length of the line segment, used to calculate the size of the paint tile
	 *  @param stroke        the stroke of the line
	 */
	public StripePaint(int angleDegrees, int segmentLength, java.awt.BasicStroke stroke) {
	}

	/**
	 *  Creates a Stripe paint that can be used to fill shapes
	 * 
	 *  @param angleRadians  the angle in radians
	 *  @param segmentLength the length of the line segment, used to calculate the size of the paint tile and therefore
	 *                       also the separation between the stripes
	 *  @param stroke        the stroke to use when painting the line
	 */
	public StripePaint(double angleRadians, int segmentLength, java.awt.BasicStroke stroke) {
	}

	/**
	 *  Returns the background colour of the paint
	 * 
	 *  @return the background colour of the paint
	 */
	public java.awt.Paint getBackground() {
	}

	/**
	 *  Specify the background colour of the paint
	 * 
	 *  @param background the background colour of the paint
	 */
	public void setBackground(java.awt.Paint background) {
	}

	/**
	 *  Returns the foreground colour of the paint
	 * 
	 *  @return the foreground colour of the paint
	 */
	public java.awt.Color getForeground() {
	}

	/**
	 *  Specify the foreground colour to use in the paint
	 * 
	 *  @param foreground the foreground colour of the paint
	 */
	public void setForeground(java.awt.Color foreground) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public int getTransparency() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public java.awt.PaintContext createContext(java.awt.image.ColorModel cm, java.awt.Rectangle deviceBounds, java.awt.geom.Rectangle2D userBounds, java.awt.geom.AffineTransform transform, java.awt.RenderingHints hints) {
	}
}
