/**
 *  The package contains util classes for JIDE Charts product.
 */
package com.jidesoft.chart.util;


/**
 *  A convenience class which implements those methods of BufferedImageOp which are rarely changed.
 */
public abstract class AbstractBufferedImageOp implements java.awt.image.BufferedImageOp, Cloneable {

	public AbstractBufferedImageOp() {
	}

	public java.awt.image.BufferedImage createCompatibleDestImage(java.awt.image.BufferedImage src, java.awt.image.ColorModel dstCM) {
	}

	public java.awt.geom.Rectangle2D getBounds2D(java.awt.image.BufferedImage src) {
	}

	public java.awt.geom.Point2D getPoint2D(java.awt.geom.Point2D srcPt, java.awt.geom.Point2D dstPt) {
	}

	public java.awt.RenderingHints getRenderingHints() {
	}

	/**
	 *  A convenience method for getting ARGB pixels from an image. This tries to avoid the performance
	 *  penalty of BufferedImage.getRGB un-managing the image.
	 *  @param image   a BufferedImage object
	 *  @param x       the left edge of the pixel block
	 *  @param y       the right edge of the pixel block
	 *  @param width   the width of the pixel array
	 *  @param height  the height of the pixel array
	 *  @param pixels  the array to hold the returned pixels. May be null.
	 *  @return the pixels
	 *  @see #setRGB
	 */
	public int[] getRGB(java.awt.image.BufferedImage image, int x, int y, int width, int height, int[] pixels) {
	}

	/**
	 *  A convenience method for setting ARGB pixels in an image. This tries to avoid the performance
	 *  penalty of BufferedImage.setRGB un-managing the image.
	 *  @param image   a BufferedImage object
	 *  @param x       the left edge of the pixel block
	 *  @param y       the right edge of the pixel block
	 *  @param width   the width of the pixel array
	 *  @param height  the height of the pixel array
	 *  @param pixels  the array of pixels to set
	 *  @see #getRGB
	 */
	public void setRGB(java.awt.image.BufferedImage image, int x, int y, int width, int height, int[] pixels) {
	}

	public Object clone() {
	}

	/**
	 *  Clamp a value to the range 0..255
	 */
	public static int clamp(int c) {
	}
}
