/**
 *  The package contains util classes for JIDE Charts product.
 */
package com.jidesoft.chart.util;


/**
 *  <p>Some utility methods for working with charts (and other components)</p>
 * 
 *  <p>Note that when exporting charts to a file immediately after they have been created, you should ensure that
 *  the chart's animateOnShow property is set to false, as otherwise you may export the first frame of the opening
 *  animation instead of the chart that you see after the animation sequence has ended.</p>
 */
public class ChartUtils {

	public ChartUtils() {
	}

	public static void setAssertEDTViolations(boolean assertViolations) {
	}

	public static boolean isAssertingEDTViolations() {
	}

	public static void assertEDT() {
	}

	public static void runOnEdt(Runnable r) {
	}

	/**
	 *  Writes a GIF image of the supplied component to the given file. In particular, you can use this method to take a
	 *  'screen shot' of a Chart component as a GIF Image.
	 * 
	 *  @param c    the component to save as an image
	 *  @param file the file to save it to
	 *  @throws FileNotFoundException
	 */
	public static void writeGifToFile(java.awt.Component c, java.io.File file) {
	}

	/**
	 *  Writes a JPEG image of the supplied component to the given file. In particular, you can use this method to take a
	 *  'screen shot' of a Chart component as a JPEG Image.
	 * 
	 *  @param c    the component to save as an image
	 *  @param file the file to save it to
	 *  @throws FileNotFoundException
	 */
	public static void writeJpegToFile(java.awt.Component c, java.io.File file) {
	}

	/**
	 *  Writes a PNG image of the supplied component to the given file. In particular, you can use this method to take a
	 *  'screen shot' of a Chart component as a PNG Image.
	 * 
	 *  @param c    the component to save as an image
	 *  @param file the file to save it to
	 *  @throws FileNotFoundException
	 */
	public static void writePngToFile(java.awt.Component c, java.io.File file) {
	}

	/**
	 *  Paints the component as a PNG image to the supplied output stream
	 * 
	 *  @param c      the component to capture as a PNG image
	 *  @param stream the stream to write the PNG data to
	 */
	public static void writeToStream(java.awt.Component c, java.io.OutputStream stream) {
	}

	/**
	 *  Creates a buffered image of type TYPE_INT_RGB from the supplied component.
	 * 
	 *  @param component the component to draw
	 *  @return an image of the component
	 */
	public static java.awt.image.BufferedImage createImage(java.awt.Component component) {
	}

	/**
	 *  Creates a buffered image (of the specified type) from the supplied component.
	 * 
	 *  @param component the component to draw
	 *  @param imageType the type of buffered image to draw
	 *  @return an image of the component
	 */
	public static java.awt.image.BufferedImage createImage(java.awt.Component component, int imageType) {
	}

	/**
	 *  Creates a thumbnail from the supplied component (such as a chart). If you want to display the thumbnail as a
	 *  component you can pass the created ImageIcon as a parameter to the constructor of a JLabel.
	 * 
	 *  @param component the component from which we would like to generate a thumbnail
	 *  @param width     the width of the thumbnail
	 *  @param height    the height of the thumbnail
	 *  @return a thumbnail Image of the supplied component
	 */
	public static java.awt.Image createThumbnailImage(java.awt.Component component, int width, int height) {
	}

	/**
	 *  Creates a thumbnail from the supplied component (such as a chart). If you want to display the thumbnail as a
	 *  component you can pass the created ImageIcon as a parameter to the constructor of a JLabel.
	 * 
	 *  @param component the component from which we would like to generate a thumbnail
	 *  @param width     the width of the thumbnail
	 *  @param height    the height of the thumbnail
	 *  @return an ImageIcon of the supplied component
	 */
	public static javax.swing.ImageIcon createThumbnail(java.awt.Component component, int width, int height) {
	}

	/**
	 *  Utility method to create a texture paint from a graphics file
	 * 
	 *  @param observer the observer to be informed when the texture image has been drawn
	 *  @param fileName the name of a file on the classpath, e.g., com/company/project/images/widget.gif
	 *  @return a TexturePaint instance
	 */
	public static java.awt.TexturePaint createTexture(javax.swing.JComponent observer, String fileName) {
	}

	/**
	 *  Creates an image from a file on the classpath
	 * 
	 *  @param path the path to the file
	 *  @return an Image object
	 */
	public static java.awt.Image createImage(String path) {
	}

	public static void clearBufferedImage(java.awt.image.BufferedImage img, java.awt.Color color) {
	}

	public static boolean isHardwareAccelerated(java.awt.Image image) {
	}

	/**
	 *  <p>Returns an array of pixels, stored as integers, from a <code>BufferedImage</code>. The pixels are grabbed from
	 *  a rectangular area defined by a location and two dimensions. Calling this method on an image of type different
	 *  from <code>BufferedImage.TYPE_INT_ARGB</code> and <code>BufferedImage.TYPE_INT_RGB</code> will unmanage the
	 *  image.</p>
	 * 
	 *  @param img    the source image
	 *  @param x      the x location at which to start grabbing pixels
	 *  @param y      the y location at which to start grabbing pixels
	 *  @param w      the width of the rectangle of pixels to grab
	 *  @param h      the height of the rectangle of pixels to grab
	 *  @param pixels a pre-allocated array of pixels of size w*h; can be null
	 *  @return <code>pixels</code> if non-null, a new array of integers otherwise
	 * 
	 *  @throws IllegalArgumentException is <code>pixels</code> is non-null and of length &lt; w*h
	 */
	public static int[] getPixels(java.awt.image.BufferedImage img, int x, int y, int w, int h, int[] pixels) {
	}

	/**
	 *  <p>Writes a rectangular area of pixels in the destination <code>BufferedImage</code>. Calling this method on an
	 *  image of type different from <code>BufferedImage.TYPE_INT_ARGB</code> and <code>BufferedImage.TYPE_INT_RGB</code>
	 *  will unmanage the image.</p>
	 * 
	 *  @param img    the destination image
	 *  @param x      the x location at which to start storing pixels
	 *  @param y      the y location at which to start storing pixels
	 *  @param w      the width of the rectangle of pixels to store
	 *  @param h      the height of the rectangle of pixels to store
	 *  @param pixels an array of pixels, stored as integers
	 *  @throws IllegalArgumentException is <code>pixels</code> is non-null and of length &lt; w*h
	 */
	public static void setPixels(java.awt.image.BufferedImage img, int x, int y, int w, int h, int[] pixels) {
	}

	/**
	 *  This method copies a 'screenshot' of the given component (such as a Chart object) to the system clipboard as a
	 *  PNG image. This can then be pasted into another application that can deal with PNG images (such as Windows Paint
	 *  or PowerPoint)
	 * 
	 *  @param component the component to take a screen-dump of
	 */
	public static void copyImageToClipboard(java.awt.Component component) {
	}

	public static java.awt.Font deriveResizedFont(java.awt.Font originalFont, java.awt.Dimension originalComponentSize, java.awt.Dimension newComponentSize) {
	}

	/**
	 *  Computes a font with a size adjusted to fit the supplied component, based on an original font and component size.
	 *  If the component has insets, then the original component size should have the sizes of the original insets subtracted.
	 *  @param originalFont the original font to be scaled
	 *  @param originalComponentSize the anticipated size of the component that matches the supplied font
	 *  @param component the component for which the font is to be tailored and rescaled
	 *  @return the original font, rescaled to suit the supplied component
	 */
	public static java.awt.Font deriveResizedFont(java.awt.Font originalFont, java.awt.Dimension originalComponentSize, javax.swing.JComponent component) {
	}
}
