/**
 *  The package contains util classes for JIDE Charts product.
 */
package com.jidesoft.chart.util;


/**
 *  The idea of this class is to produce any number of colors, but the colors should be different to one another so that
 *  they can be picked out visually in a chart.
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class ColorFactory {

	public ColorFactory() {
	}

	/**
	 *  This constructor allows you to set the transparency of the generated colors as well as provide a sequence of
	 *  colors to use initially
	 * 
	 *  @param transparency     a value between 0 (transparent) and 255 (opaque)
	 *  @param initialColors the first colours to use in the generated sequence
	 */
	public ColorFactory(int transparency, java.awt.Color[] initialColors) {
	}

	/**
	 *  Sets up a predetermined sequence of colors to use initially
	 * 
	 *  @param initialColors the colors to start with
	 */
	public ColorFactory(java.awt.Color[] initialColors) {
	}

	public void clear() {
	}

	/**
	 *  @return the transparency value
	 */
	public int getTransparency() {
	}

	/**
	 *  Sets the transparency value
	 * 
	 *  @param transparency the new transparency value
	 */
	public void setTransparency(int transparency) {
	}

	public double getMinSaturation() {
	}

	/**
	 *  A value between 0 and 1
	 */
	public void setMinSaturation(double minSaturation) {
	}

	public double getMaxSaturation() {
	}

	/**
	 *  A value between 0 and 1
	 */
	public void setMaxSaturation(double maxSaturation) {
	}

	public double getMinBrightness() {
	}

	/**
	 *  A value between 0 and 1
	 */
	public void setMinBrightness(double minBrightness) {
	}

	public double getMaxBrightness() {
	}

	/**
	 *  A value between 0 and 1
	 */
	public void setMaxBrightness(double maxBrightness) {
	}

	/**
	 *  The distance measure between the two supplied colors in red, green, blue space.
	 * 
	 *  @param color1 a color
	 *  @param color2 another color
	 *  @return the distance between the two colors
	 */
	public static double distance(java.awt.Color color1, java.awt.Color color2) {
	}

	/**
	 *  Returns the distance of the closest color generated
	 *  @param color the color of interest
	 *  @return the distance of the closest color generated, according to the <code>distance(color, color)</code> method.
	 */
	public double closest(java.awt.Color color) {
	}

	public java.awt.Color create() {
	}

	/**
	 *  Intensify a colour by applying the supplied offset
	 *  @param c the original colour
	 *  @param offset a value between -255 and 255 to add to each of the rgb components
	 *  @return a new colour with the offset applied. If the new colour would be negative it is set to 0 and if
	 *  greater than 255 it is set to 255.
	 */
	public static java.awt.Color intensify(java.awt.Color c, int offset) {
	}

	/**
	 *  This method of intensifying a colour distributes intensity wherever it can. If one of the primary colours gets
	 *  to 255, then the colour points that the colour would have received are given to the other colours.
	 *  @param c the original color
	 *  @param offset the amount by which to change the color, in the range 0 to 255
	 *  @return the new intensified <code>Color</code> object
	 */
	public static java.awt.Color intensify2(java.awt.Color c, int offset) {
	}

	/**
	 *  Create a color that lies on the 'color line' between the supplied fromColor and toColor.
	 *  The position parameter dictates where along the color line the new color will be. This
	 *  parameter should be in the range [0, 1]. If the value is 0, the returned color is the same
	 *  as the fromColor; if it is 1, it the same as the toColor.
	 *  @param fromColor one point at the end of the color line
	 *  @param toColor another point at the end of the color line
	 *  @param position the position along the color line
	 *  @return a new Color
	 */
	public static java.awt.Color transitionColor(java.awt.Color fromColor, java.awt.Color toColor, double position) {
	}
}
