/**
 *  The package contains util classes for JIDE Charts product.
 */
package com.jidesoft.chart.util;


/**
 *  An interface for objects that implement an inclusion/exclusion rule on some other type T 
 * 
 *  @param <T> the type of object that the filter can operate on
 */
public interface Filter {

	/**
	 *  Specifies whether the object should be removed by the filter
	 * 
	 *  @param other the input object to test for removal
	 *  @return a boolean to indicate whether the object is to be removed
	 */
	public boolean isValueFiltered(Object other);
}
