/**
 *  The package contains util classes for JIDE Charts product.
 */
package com.jidesoft.chart.util;


/**
 *  A filter which adds random noise into an image.
 */
public class NoiseFilter extends PointFilter {

	/**
	 *  Gaussian distribution for the noise.
	 */
	public static final int GAUSSIAN = 0;

	/**
	 *  Uniform distribution for the noise.
	 */
	public static final int UNIFORM = 1;

	public NoiseFilter() {
	}

	/**
	 *  Set the amount of effect.
	 *  @param amount the amount (default value 25)
	 *  @see #getAmount
	 */
	public void setAmount(int amount) {
	}

	/**
	 *  Get the amount of noise.
	 *  @return the amount
	 *  @see #setAmount
	 */
	public int getAmount() {
	}

	/**
	 *  Set the distribution of the noise.
	 *  @param distribution the distribution
	 *  @see #getDistribution
	 */
	public void setDistribution(int distribution) {
	}

	/**
	 *  Get the distribution of the noise.
	 *  @return the distribution
	 *  @see #setDistribution
	 */
	public int getDistribution() {
	}

	/**
	 *  Set whether to use monochrome noise.
	 *  @param monochrome true for monochrome noise
	 *  @see #getMonochrome
	 */
	public void setMonochrome(boolean monochrome) {
	}

	/**
	 *  Get whether to use monochrome noise.
	 *  @return true for monochrome noise
	 *  @see #setMonochrome
	 */
	public boolean getMonochrome() {
	}

	/**
	 *  Set the density of the noise.
	 *  @param density the density
	 *  @see #getDensity
	 */
	public void setDensity(float density) {
	}

	/**
	 *  Get the density of the noise.
	 *  @return the density
	 *  @see #setDensity
	 */
	public float getDensity() {
	}

	public int filterRGB(int x, int y, int rgb) {
	}

	public String toString() {
	}
}
