/**
 *  The package contains util classes for JIDE Charts product.
 */
package com.jidesoft.chart.util;


/**
 *  A generic class that contains a pair of two objects of types T and U. This class is useful when you
 *  want to bind two objects together without the overhead of creating a custom class.
 * 
 *  Note that you can use wild-cards when creating Pairs:
 *  <code>Pair&lt;? extends Number, ? extends Number&gt; p = new Pair&lt;Integer, Integer&gt;(1, 2); </code>
 * 
 *  @author swhite@catalysoft.com
 *  @param <T> the type of the first element of the pair
 *  @param <U> the type of the second element of the pair
 */
public class Pair {

	/**
	 *  Creates a Pair in which both elements are null
	 */
	public Pair() {
	}

	/**
	 *  Creates a Pair using the supplied first and second parameters as the values for the <em>first</em>
	 *  and <em>second</em> properties, respectively.
	 *  @param first the first element of the pair
	 *  @param second the second element of the pair
	 */
	public Pair(Object first, Object second) {
	}

	/**
	 *  Specify the first element of the pair
	 *  @param first the first element of the pair
	 */
	public void setFirst(Object first) {
	}

	/**
	 *  Specify the second element of the pair
	 *  @param second the second element of the pair
	 */
	public void setSecond(Object second) {
	}

	/**
	 *  Retrieve the first element of the pair
	 *  @return the first element of the pair
	 */
	public Object getFirst() {
	}

	/**
	 *  Retrieve the second element of the pair
	 *  @return the second element of the pair
	 */
	public Object getSecond() {
	}

	@java.lang.Override
	public String toString() {
	}
}
