/**
 *  The package contains classes related to parsing CSV (comma-separated values) files and tab-separated files for JIDE Charts product.
 */
package com.jidesoft.csv;


/**
 *  An event generated when a token or a line is recognised in the input stream or file.
 *  <p>
 *  This class now supports storing of the line of tokens with the <code>setTokens()</code> method.
 *  </p>
 *  @author Simon White (swhite@catalysoft.com)
 */
public class CsvParseEvent extends java.util.EventObject {

	public CsvParseEvent(Object source, CsvParseEvent.EventType type) {
	}

	public CsvParseEvent(Object source, CsvParseEvent.EventType type, String token) {
	}

	public CsvParseEvent(Object source, String token) {
	}

	public CsvParseEvent(Object source, java.util.List tokens) {
	}

	public void setToken(String token) {
	}

	public String getToken() {
	}

	public void setTokens(java.util.List tokens) {
	}

	public java.util.List getTokens() {
	}

	public CsvParseEvent.EventType getType() {
	}

	@java.lang.Override
	public String toString() {
	}

	/**
	 *  Indicates whether the event signifies a token or a line
	 *  @author Simon White (swhite@catalysoft.com)
	 */
	public static final class EventType {


		public static final CsvParseEvent.EventType TOKEN;

		public static final CsvParseEvent.EventType LINE;

		/**
		 *  Reached the start of the input stream
		 */
		public static final CsvParseEvent.EventType INPUT_START;

		/**
		 *  Reached the end of the input stream
		 */
		public static final CsvParseEvent.EventType INPUT_END;

		/**
		 *  This is deprecated and will be removed sometime after release 3.3.1
		 */
		public static final CsvParseEvent.EventType FILE;

		public static CsvParseEvent.EventType[] values() {
		}

		public static CsvParseEvent.EventType valueOf(String name) {
		}
	}
}
