/**
 *  The package contains classes related to parsing CSV (comma-separated values) files and tab-separated files for JIDE Charts product.
 */
package com.jidesoft.csv;


/**
 *  A class for reading comma-separated values files and streams. Actually the inputs do not have to be comma-separated - you can
 *  specify the character that is used as a separator.
 *  <p>Values containing commas can be provided by putting the value in double quotes. For example, p,"a,b,c",q is a sequence of
 *  three values, not five.</p>
 * 
 *  <p>Apparently it is a contentious issue whether spaces around the values (and next to a separator) are trimmed. It appears
 *  to be common practice and yet contrary to RFC 4180, so I have provided a property <code>trimmingValues</code> that allows 
 *  the user to specify whether values should be trimmed. By default, trimming is switched on.</p>
 * 
 *  <p>If you need to provide a double quote character while inside a quoted token, use two double-quotes next to one another.</p>
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class CsvReader {

	public CsvReader() {
	}

	public CsvReader(char separator) {
	}

	public CsvReader(java.io.Reader reader) {
	}

	public CsvReader(java.io.Reader reader, char separator) {
	}

	/**
	 *  Provide some forewarning of the number of lines that will need to be processed, so that data structures do not
	 *  have to be resized dynamically.
	 *  @param numLines the number of lines to expect in the input
	 */
	public void ensureCapacity(int numLines) {
	}

	/**
	 *  Sets the reader as the source of data. If the Reader is not a BufferedReader, it will automatically be wrapped
	 *  in a BufferedReader
	 *  @param reader the reader that provides the data
	 */
	public void setReader(java.io.Reader reader) {
	}

	/**
	 *  Returns a BufferedReader. If a BufferedReader was not supplied in the setter, then the supplied
	 *  reader will have been wrapped in BufferedReader, which will be returned here.
	 *  @return a BufferedReader
	 */
	public java.io.Reader getReader() {
	}

	public void setSeparator(char separator) {
	}

	public char getSeparator() {
	}

	public boolean isTrimmingValues() {
	}

	public void setTrimmingValues(boolean trimmingValues) {
	}

	public java.util.List parse(java.io.File file) {
	}

	public java.util.List parse(java.io.InputStream is) {
	}

	public static boolean isBufferedReader(java.io.Reader reader) {
	}

	public java.util.List parse() {
	}

	public java.util.List parse(java.io.Reader reader) {
	}

	/**
	 *  A special method that does not return any parsed data but relies on the
	 *  supplied listener to do any necessary processing. This can be useful when
	 *  processing large files, as the whole of the input file does not need to
	 *  stored in main memory.
	 *  <p>We call this <code>parseForEffects</code> to emphasize that the responsibility
	 *  for dealing with the results of parsing is with the user of this class, through
	 *  the supplied <code>CsvParseListener</code>.
	 *  </p>
	 *  @param listener the listener that will be notified of events and associated data during parsing
	 *  @throws IOException
	 */
	public void parseForEffects(CsvParseListener listener) {
	}
}
