/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  An abstract superclass for gauge components. A <code>Dial</code> is a Gauge component and we are introducing a new Gauge
 *  component called <code>Bullet</code>.
 */
public abstract class AbstractGauge extends javax.swing.JComponent implements GaugeModelListener, com.jidesoft.chart.ResizableComponent {

	public static final String DEFAULT_NEEDLE_NAME = "default";

	public static final String PROPERTY_BACKGROUND_PAINT = "Background Paint";

	public static final String PROPERTY_RESIZE_FONTS = "Resize Fonts";

	public AbstractGauge() {
	}

	/**
	 *  This is the method of the GaugeModelListener interface
	 * 
	 *  @param e the GaugeModelEvent
	 */
	public void gaugeChanged(GaugeModelEvent e) {
	}

	public GaugeModel getModel() {
	}

	public void setModel(GaugeModel model) {
	}

	/**
	 *  @return the current value of the gauge
	 */
	public Double getValue() {
	}

	public Double getValue(String needleName) {
	}

	/**
	 *  When the supplied value is a double and we need to create a Positionable object this method is called to create
	 *  that object. By default, it creates a <code>RealPosition</code> but if necessary you can override the method to
	 *  create an instance of a different class.
	 * 
	 *  @param value the double that we need to convert to a Positionable object
	 *  @return a Positionable object
	 */
	protected Positionable createPositionable(Double value) {
	}

	public void setValue(int value) {
	}

	/**
	 *  Set the value of the gauge
	 * 
	 *  @param value the new value
	 */
	public void setValue(Double value) {
	}

	/**
	 *  Set the value of the specified needle
	 * 
	 *  @param needleName the needle whose value we are setting
	 *  @param value      the value of the needle
	 */
	public void setValue(String needleName, Double value) {
	}

	/**
	 *  Set the value of the specified needle
	 * 
	 *  @param needleName the needle whose value we are setting
	 *  @param value      the value of the needle
	 */
	public void setValue(String needleName, int value) {
	}

	/**
	 *  Set the value of the specified needle
	 * 
	 *  @param needleName the needle whose value we are setting
	 *  @param pos        a Positionable object that carries the value of the needle (and possibly other information
	 *                    too)
	 */
	public void setValue(String needleName, Positionable pos) {
	}

	/**
	 *  Set the value of the specified needle
	 * 
	 *  @param needleName the needle whose value we are setting
	 *  @param value      the value of the needle
	 *  @param fireUpdate specify whether an update event should be fired on the model
	 */
	public void setValue(String needleName, double value, boolean fireUpdate) {
	}

	public abstract void setValue(String needleName, Positionable pos, boolean fireUpdate) {
	}

	protected abstract java.awt.geom.Point2D calculatePixelPoint2D(Object axis, double value) {
	}

	public boolean isShadowVisible() {
	}

	public void setShadowVisible(boolean shadowVisible) {
	}

	/**
	 *  Specify whether to automatically resize fonts
	 * 
	 *  @param resizeFonts whether to automatically resize fonts
	 */
	public void setResizeFonts(boolean resizeFonts) {
	}

	/**
	 *  Return a boolean to indicate whether fonts are being auto-resized.
	 *  @return a boolean to indicate whether fonts are being auto-resized.
	 */
	public boolean isResizeFonts() {
	}

	/**
	 *  Returns the component size used for comparison when font resizing is switched on
	 * 
	 *  @return the component size used for comparison when font resizing is switched on
	 */
	public java.awt.Dimension getFontComparisonSize() {
	}

	/**
	 *  Specify the size that will be used to determine the new font size when resizing. In effect, this property
	 *  calibrates the font resizing, but is used only if the resizeFonts property is also set to true. If you don't set
	 *  the property explicitly then it will be set at the size that this component is first shown.
	 * 
	 *  @param fontComparisonSize a component size for which tick labels will be shown at their specified size
	 */
	public void setFontComparisonSize(java.awt.Dimension fontComparisonSize) {
	}

	/**
	 *  Returns the current font size ratio, when auto-resizing fonts
	 * 
	 *  @return the computed font size ratio
	 */
	public float getFontSizeRatio() {
	}

	protected void setFontSizeRatio(float fontSizeRatio) {
	}

	/**
	 *  Returns the tick label font to be used for the supplied axis. This depends on both the size
	 *  of the Dial component (assuming resizeFonts is switched on) and the font supplied by the axis.
	 * 
	 *  @param axis the axis of interest
	 *  @return a Font whose size style is determined by the axis and size determined by the size of this dial
	 */
	public java.awt.Font tickLabelFontForAxis(AbstractNumericGaugeAxis axis) {
	}

	/**
	 *  We would like to provide the ability to get/set a Paint as the background
	 *  rather than just a Color, so we provide that ability through this property.
	 *  However, if the property has not been set with a Paint instance, then this
	 *  method returns a Color instance by internally calling Component.getBackground() instead.
	 *  @return a Paint instance (which may be a Color)
	 */
	public java.awt.Paint getBackgroundPaint() {
	}

	/**
	 *  Specify the background to use for this gauge. This is like the setBackground() method of JComponent, except that
	 *  you can supply a Paint instance rather than just a Color. This opens up the possibilities with gradient effects.
	 * 
	 *  @param background the background Paint
	 */
	public void setBackgroundPaint(java.awt.Paint background) {
	}

	protected java.awt.Color getAncestorBackground() {
	}

	protected String longestTickLabel(java.util.Collection ticks, java.awt.FontMetrics fm) {
	}

	/**
	 *  Paints a string but only if the whole of the string will be visible according to the bounds of the component
	 * 
	 *  @param g the <code>Graphics</code> context
	 *  @param s the string to draw
	 *  @param x the bottom left x coordinate of the drawn string
	 *  @param y the bottom left y coordinate of the drawn string
	 *  @return a boolean to indicate whether the string was actually drawn
	 */
	protected boolean drawStringIfWithinBounds(java.awt.Graphics2D g, String s, float x, float y) {
	}

	/**
	 *  @param g        the Graphics context into which to draw
	 *  @param s        the string to draw
	 *  @param x        the x coordinate of the centre of where the string should be drawn
	 *  @param y        the y coordinate of the centre of where the string should be drawn
	 *  @param rotation the rotation to use, in radians
	 *  @return a boolean to indicate whether the string was drawn
	 */
	protected boolean drawRotatedStringIfWithinBounds(java.awt.Graphics g, java.awt.Font f, String s, float x, float y, double rotation) {
	}

	/**
	 *  Returns the property that specifies whether tick labels are allowed to overlap
	 * 
	 *  @return the property that specifies whether tick labels are allowed to overlap
	 */
	public boolean isAllowTickLabelOverlap() {
	}

	/**
	 *  Normally you would not want your tick labels to overlap, but this property provides for this as a possibility.
	 *  The default value is false, but you could set it true to perhaps configure the appearance of a fixed size dial.
	 * 
	 *  @param allowTickLabelOverlap specify whether tick labels are allowed to overlap
	 */
	public void setAllowTickLabelOverlap(boolean allowTickLabelOverlap) {
	}
}
