/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


public abstract class AbstractGaugeTickStyle {

	protected java.awt.Color tickColor;

	/**
	 *  Determines whether the ticks of this type will be visible.
	 */
	protected boolean visible;

	/**
	 *  Tick Length is specified in terms of the proportion of the axis width
	 */
	protected double tickLength;

	/**
	 *  Tick width is specified as a percentage of the radius of the Gauge.
	 *  The ratio is usually small, so making it a percentage makes it easier to deal with. A tickWidth of around 1 or
	 *  0.5 usually gives good results.
	 *  The tick width is related to the radius size so that the tick width does not have to be adjusted when the axis width changes
	 */
	protected double tickWidth;

	public AbstractGaugeTickStyle() {
	}

	/**
	 *  Returns the color of the ticks
	 *  @return the color of the ticks
	 */
	public java.awt.Color getTickColor() {
	}

	/**
	 *  Specify the color to use for ticks
	 *  @param tickColor the color to use for ticks
	 */
	public void setTickColor(java.awt.Color tickColor) {
	}

	/**
	 *  Returns the length of ticks, specified as a proportion of axis width
	 *  @return the length of ticks, specified as a proportion of axis width
	 */
	public double getTickLength() {
	}

	/**
	 *  Specify the length of ticks, supplied as a proportion of axis width
	 *  @param tickLength the length of ticks as a proportion of axis width
	 */
	public void setTickLength(double tickLength) {
	}

	/**
	 *  Returns the width of ticks, specified as a <em>percentage</em> of the radius of the Gauge.
	 *  A tick width of around 1 or 0.5 usually gives good results.
	 *  @return the width of ticks, specified as a percentage of the radius of the Gauge.
	 */
	public double getTickWidth() {
	}

	/**
	 *  Tick width is specified as a <em>percentage</em> of the radius of the Gauge.
	 *  The ratio is usually small, so making it a percentage makes it easier to deal with. A tickWidth of around 1 or
	 *  0.5 usually gives good results.
	 *  The tick width is related to the radius size so that the tick width does not have to be adjusted when the axis width changes
	 */
	public void setTickWidth(double tickWidth) {
	}

	/**
	 *  Returns a boolean to indicate whether the ticks are visible
	 *  @return a boolean to indicate whether the ticks are visible
	 */
	public boolean isVisible() {
	}

	/**
	 *  Specify whether the ticks are visible
	 *  @param visible a boolean to indicate whether ticks are visible
	 */
	public void setVisible(boolean visible) {
	}

	@java.lang.Override
	public boolean equals(Object o) {
	}

	@java.lang.Override
	public int hashCode() {
	}
}
