/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


public abstract class AbstractIndicatorRenderer implements IndicatorRenderer, com.jidesoft.chart.ZOrder {

	protected java.awt.Font labelFont;

	protected java.awt.Color labelColor;

	protected boolean labelVisible;

	protected AbstractIndicatorRenderer() {
	}

	public ShadowRenderer getShadowRenderer() {
	}

	public void setShadowRenderer(ShadowRenderer shadowRenderer) {
	}

	/**
	 *  Returns the labeler that generates a string to be used as a label for the indicator
	 *  @return the labeler that generates a string to be used as a label for the indicator
	 */
	public com.jidesoft.chart.render.NumberLabeler getLabeler() {
	}

	/**
	 *  Specify a labeler that can be used to dynamically generate the string for the label, usually based on the
	 *  value of the indicator.
	 *  @param labeler the labeler that converts a numeric value into a string for display as the label
	 */
	public void setLabeler(com.jidesoft.chart.render.NumberLabeler labeler) {
	}

	/**
	 *  Returns the fixed label text specified with setLabelText()
	 *  @return the fixed string specified as a label for the indicator
	 */
	public String getLabelText() {
	}

	/**
	 *  Use this method to specify a static value for the text of the label. Note that if a labeler is specified
	 *  in addition to a labelText, the labeler will be used to generate the text value in preference to any
	 *  fixed text value specified here.
	 *  @param labelText the fixed label text
	 */
	public void setLabelText(String labelText) {
	}

	protected String generateLabel(Double value) {
	}

	public java.awt.Font getLabelFont() {
	}

	public void setLabelFont(java.awt.Font labelFont) {
	}

	public java.awt.Color getLabelColor() {
	}

	public void setLabelColor(java.awt.Color labelColor) {
	}

	public boolean isLabelVisible() {
	}

	public void setLabelVisible(boolean labelVisible) {
	}

	public int getZOrder() {
	}

	public void setZOrder(int zOrder) {
	}

	@java.lang.Override
	public java.awt.Shape paintIndicator(java.awt.Graphics2D g, AbstractGauge gauge, Double value, IndicatorStyle style) {
	}

	public abstract void paintLabel(java.awt.Graphics2D g, AbstractGauge gauge, Double value, IndicatorStyle style) {
	}

	protected abstract void drawIndicator(java.awt.Graphics2D g, AbstractGauge gauge, java.awt.Shape shape, IndicatorStyle style) {
	}

	/**
	 *  Calculates the shape of the indicator. This is needed so that we can create a BufferedImage of the right
	 *  size when generating shadows
	 *  @param gauge the gauge, such as an instance of Bullet
	 *  @param value the value to be represented by the indicator
	 */
	protected abstract java.awt.Shape calculateShape(AbstractGauge gauge, Double value) {
	}
}
