/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  An abstract superclass for the axes of gauges
 *  @param <TickStyle> the style of the ticks, which may vary depending on the type of the axis and/or gauge
 */
public class AbstractNumericGaugeAxis {

	public static final String PROPERTY_RANGE = "Range";

	public static final String PROPERTY_MAJOR_TICK_STYLE = "MajorTickStyle";

	public static final String PROPERTY_MINOR_TICK_STYLE = "MinorTickStyle";

	public static final String PROPERTY_MAJOR_TICK = "MajorTick";

	public static final String PROPERTY_MINOR_TICK = "MinorTick";

	protected NumericRange range;

	protected double majorTickInterval;

	protected double minorTickInterval;

	protected java.beans.PropertyChangeSupport support;

	public AbstractNumericGaugeAxis() {
	}

	public AbstractNumericGaugeAxis(double rangeStart, double rangeEnd) {
	}

	public AbstractNumericGaugeAxis(double rangeStart, double rangeEnd, double majorTickInterval, double minorTickInterval) {
	}

	/**
	 *  Change the range of the axis to the specified range start and end values
	 *  @param rangeStart the start of the range
	 *  @param rangeEnd the end of the range
	 */
	public void setRange(double rangeStart, double rangeEnd) {
	}

	/**
	 *  Change the range of the axis to the specified range
	 *  @param range the new range for the gauge
	 */
	public void setRange(NumericRange range) {
	}

	public NumericRange getRange() {
	}

	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	public double getMajorTickInterval() {
	}

	public void setMajorTickInterval(double majorTickInterval) {
	}

	public double getMinorTickInterval() {
	}

	public void setMinorTickInterval(double minorTickInterval) {
	}

	public java.text.NumberFormat getNumberFormat() {
	}

	/**
	 *  Specify a number format for the tick labels along the axis
	 *  @param numberFormat the number format to use when preparing tick labels
	 */
	public void setNumberFormat(java.text.NumberFormat numberFormat) {
	}

	protected void updateTicks() {
	}

	protected com.jidesoft.chart.axis.NumericTickCalculator createTickCalculator(double rangeMin, double rangeMax, double majorTickInterval, double minorTickInterval) {
	}

	public java.util.List ticks() {
	}

	public double minimum() {
	}

	public double maximum() {
	}

	public AbstractGaugeTickStyle getMajorTickStyle() {
	}

	public void setMajorTickStyle(AbstractGaugeTickStyle tickStyle) {
	}

	public AbstractGaugeTickStyle getMinorTickStyle() {
	}

	public void setMinorTickStyle(AbstractGaugeTickStyle tickStyle) {
	}

	public java.awt.Font getTickLabelFont() {
	}

	public void setTickLabelFont(java.awt.Font tickLabelFont) {
	}

	/**
	 *  Get the current tick label color
	 *  @return the tick label color
	 */
	public java.awt.Color getTickLabelColor() {
	}

	/**
	 *  Specify the color to use when painting the tick labels.
	 *  If the tick label color is null the tick label will not be painted.
	 *  @param tickLabelColor the color for the tick labels
	 */
	public void setTickLabelColor(java.awt.Color tickLabelColor) {
	}

	@java.lang.Override
	public String toString() {
	}
}
