/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A Bullet Chart class
 */
public class Bullet extends AbstractGauge {

	/**
	 *  Any Drawables with a Z order less than this value will be painted before the indicators;
	 *  any Drawables with a Z order greater than this value will be painted after the indicators.
	 */
	public static final int INDICATOR_Z_ORDER = 100;

	public static final String DEFAULT_INDICATOR_NAME = "default";

	public static final String PROPERTY_BULLET_FOREGROUND = "Bullet Foreground";

	public static final String PROPERTY_BULLET_BACKGROUND = "Bullet Background";

	public Bullet() {
	}

	public Bullet(java.awt.Dimension d) {
	}

	/**
	 *  Returns the axis for the Bullet. If the bullet has more than one axis, this method returns the first one.
	 *  @return the axis for the Bullet
	 */
	public BulletAxis getAxis() {
	}

	/**
	 *  Set the axis for the bullet. If the axis already contains one or more axes, these are first removed.
	 *  @param axis the axis to set for the bullet.
	 */
	public void setAxis(BulletAxis axis) {
	}

	/**
	 *  Add the specified axis to the Bullet. If you have already specified an axis using setAxis(), this method enables
	 *  you to add a second one.
	 *  @param axis the axis to add to the bullet.
	 */
	public void addAxis(BulletAxis axis) {
	}

	/**
	 *  Returns the current proportional insets
	 *  @return the current insets
	 */
	public Insets2D getProportionalInsets() {
	}

	/**
	 *  Specify proportional insets that improve scalability of the component
	 *  @param insets2D the insets
	 */
	public void setProportionalInsets(Insets2D insets2D) {
	}

	/**
	 *  Returns the orientation of the Bullet (horizontal or vertical)
	 *  @return the orientation of the Bullet
	 */
	public com.jidesoft.chart.Orientation getOrientation() {
	}

	/**
	 *  Specify the orientation of the bullet
	 *  @param orientation the orientation of the bullet chart (horizontal or vertical)
	 */
	public void setOrientation(com.jidesoft.chart.Orientation orientation) {
	}

	/**
	 *  Returns the default indicator renderer (used when no value-specific renderer is defined)
	 *  @return the default indicator renderer
	 */
	public IndicatorRenderer getRenderer() {
	}

	/**
	 *  Specify the default IndicatorRenderer
	 *  @param renderer the renderer that will be used unless a value-specific one is set
	 */
	public void setRenderer(IndicatorRenderer renderer) {
	}

	/**
	 *  Returns the renderer specified for the given value tag
	 *  @param valueName the name of the value
	 *  @return the renderer specified for the value
	 */
	public IndicatorRenderer getRenderer(String valueName) {
	}

	/**
	 *  Specify the renderer for the given value tag
	 *  @param valueName the name of the value
	 *  @param renderer the renderer to use for the value
	 */
	public void setRenderer(String valueName, IndicatorRenderer renderer) {
	}

	/**
	 *  Adds a Drawable object to the dial
	 * 
	 *  @param drawable the Drawable to add
	 *  @see DialIntervalMarker
	 *  @see DialLabel
	 */
	public void addDrawable(com.jidesoft.chart.Drawable drawable) {
	}

	/**
	 *  Removes the specified Drawable from the dial
	 * 
	 *  @param drawable the drawable to remove
	 */
	public void removeDrawable(com.jidesoft.chart.Drawable drawable) {
	}

	/**
	 *  Removes all Drawables from the dial
	 */
	public void removeDrawables() {
	}

	/**
	 *  Returns the background paint to use for the bullet area
	 *  @return the background paint to use for the bullet area
	 */
	public java.awt.Paint getBulletBackground() {
	}

	/**
	 *  Specify the background paint to use for the bullet area
	 *  @param bulletBackground the background to use for the bullet area
	 */
	public void setBulletBackground(java.awt.Paint bulletBackground) {
	}

	/**
	 *  returns the Border that is used for the bullet area
	 *  @return the Border for the bullet
	 */
	public javax.swing.border.Border getBulletBorder() {
	}

	/**
	 *  Specify the Border to use for the bullet area
	 *  @param bulletBorder the Border to use for the bullet area
	 */
	public void setBulletBorder(javax.swing.border.Border bulletBorder) {
	}

	/**
	 *  Returns the shape that was rendered for the supplied value
	 *  @param valueName the name of the value in which we are interested
	 *  @return the Shape outline that was used to render the value (or null if none found)
	 */
	public java.awt.Shape renderedAs(String valueName) {
	}

	/**
	 *  Discovers the values that were rendered at the supplied pixel location
	 *  @param p the pixel location of interest (usually the cursor position)
	 *  @return a List of values (usually none or one, but can be more) rendered at the supplied pixel position
	 */
	public java.util.List containingShapes(java.awt.Point p) {
	}

	/**
	 *  Returns the names of the values that were rendered and have shapes stored
	 *  @return
	 */
	public java.util.List renderedValues() {
	}

	public int getXEnd() {
	}

	public int getXStart() {
	}

	/**
	 *  yEnd is the y coordinate at the top of the component after taking account of any border inset
	 *  @return the y coordinate at the top of the component after taking account of any border inset
	 */
	public int getYEnd() {
	}

	/**
	 *  yStart is the y coordinate at the bottom of the component after taking account of any border inset
	 *  @return the y coordinate at the bottom of the component after taking account of any border inset
	 */
	public int getYStart() {
	}

	/**
	 *  midY is the y coordinate at the centre of the bullet part of the display (ie. not the centre of the component)
	 *  @return the y coordinate at the centre of the bullet part of the display
	 */
	public double getMidY() {
	}

	/**
	 *  midX is the x coordinate at the centre of the bullet part of the display (ie. not the centre of the component)
	 *  @return the x coordinate at the centre of the bullet part of the display
	 */
	public double getMidX() {
	}

	/**
	 *  Set the value of the specified indicator on the primary axis
	 * 
	 *  @param indicatorName the indicator whose value we are setting
	 *  @param pos        a Positionable object that carries the value of the indicator (and possibly other information
	 *                    too)
	 *  @param fireUpdate specify whether an update event should be fired on the model
	 */
	public void setValue(String indicatorName, Positionable pos, boolean fireUpdate) {
	}

	/**
	 *  You can clear an individual style by setting it to null. In this case a default style will be used.
	 *  @param indicatorName the name of the value for which the style is being specified
	 *  @param style the style to assign to the value rendering
	 */
	public Bullet addIndicator(String indicatorName, IndicatorStyle style) {
	}

	public void removeIndicator(String indicatorName) {
	}

	public void removeIndicators() {
	}

	/**
	 *  Sets the style for the default value. Use this if you are displaying only one value.
	 *  @param style the style for the default bullet value
	 */
	public void setIndicatorStyle(IndicatorStyle style) {
	}

	/**
	 *  You can clear an individual style by setting it to null. In this case a default style will be used.
	 *  @param indicatorName the name of the value for which the style is being specified
	 *  @param style the style to assign to the value rendering
	 */
	public void setIndicatorStyle(String indicatorName, IndicatorStyle style) {
	}

	public IndicatorStyle getIndicatorStyle(String indicatorName) {
	}

	public void removeStyles() {
	}

	protected double calculatePixelCoordinate(BulletAxis axis, double value) {
	}

	@java.lang.Override
	protected java.awt.geom.Point2D calculatePixelPoint2D(BulletAxis axis, double value) {
	}

	public void update() {
	}

	/**
	 *  Returns the breadth of the bullet in pixels
	 *  @return the breadth of the bullet in pixels
	 */
	public double getBulletBreadth() {
	}

	/**
	 *  Returns the breadth of the bullet as a proportion of its length
	 *  @return the breadth of the bulelt as a proportion of its length
	 */
	public double getBreadthProportion() {
	}

	/**
	 *  Set the breadth of the bullet as a proportion of its length; by default 0.1
	 *  @param breadthProportion the breadth of the bullet as a proportion of its length
	 */
	public void setBreadthProportion(double breadthProportion) {
	}

	@java.lang.Override
	protected void paintComponent(java.awt.Graphics g) {
	}

	protected java.awt.geom.Rectangle2D paintBulletBackground(java.awt.Graphics2D g2d) {
	}

	protected void paintBulletBorder(java.awt.Graphics2D g2d) {
	}

	protected void paintAxis(java.awt.Graphics2D g, BulletAxis axis) {
	}
}
