/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A marker class for a coloured region along a Bullet.
 *  Note that the recommended approach is to use varying intensities of a single hue for marking the interval ranges,
 *  to make them easily discernible by those who are colour blind and to keep the number of colours on a dashboard
 *  display to a minimum.
 */
public class BulletIntervalMarker implements com.jidesoft.chart.Drawable {

	/**
	 *  Constructs a BulletIntervalMarker for the specified Bullet, using COLOR.GRAY as the fill Color
	 *  and ranging between the given from and to values.
	 *  @param bullet the bullet to which this marker will be applied
	 *  @param from the start of the marker region
	 *  @param to the end of the marker region
	 */
	public BulletIntervalMarker(Bullet bullet, double from, double to) {
	}

	/**
	 *  Constructs a BulletIntervalMarker for the specified Bullet, using the supplied fill value for the Color
	 *  and ranging between the given from and to values.
	 *  @param bullet the bullet to which this marker will be applied
	 *  @param fill the Color/Paint to use for filling in the body of the marker
	 *  @param from the start of the marker region
	 *  @param to the end of the marker region
	 */
	public BulletIntervalMarker(Bullet bullet, java.awt.Paint fill, double from, double to) {
	}

	/**
	 *  You can call this method to change the interval for the intervalMarker
	 *  @param from the start of the interval
	 *  @param to the end of the interval
	 */
	public void setInterval(double from, double to) {
	}

	/**
	 *  Returns the 'from' value for the interval
	 *  @return the 'from' value for the interval
	 */
	public double getFrom() {
	}

	/**
	 *  Returns the 'to' value for the interval
	 *  @return the 'to' value for the interval
	 */
	public double getTo() {
	}

	/**
	 *  Returns the value that determines how much of the breadth of the bullet is covered by this marker
	 *  @return a value between 0 and 1
	 */
	public double getBreadthProportion() {
	}

	/**
	 *  Specify how much of the breadth of the bullet should be taken up by this marker. By default this is 1.
	 *  @param breadthProportion a value between 0 and 1 (inclusive)
	 */
	public void setBreadthProportion(double breadthProportion) {
	}

	/**
	 *  Returns the current Color (or other paint) for the body of the interval
	 *  @return the Paint for the body of the interval marker
	 */
	public java.awt.Paint getFill() {
	}

	/**
	 *  Specify the Color (or other Paint fill) to use for filling the body of the interval
	 *  @param fill the fill Color (or Paint) for the indicated range along the primary axis
	 */
	public void setFill(java.awt.Paint fill) {
	}

	/**
	 *  The method of the Drawable interface.
	 *  @param g the Graphics context
	 */
	@java.lang.Override
	public void draw(java.awt.Graphics g) {
	}
}
