/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A marker class for a specific value along a Bullet.
 */
public class BulletPointMarker implements com.jidesoft.chart.Drawable {

	/**
	 *  Constructs a BulletPointMarker for the specified Bullet, using COLOR.GRAY as the fill Color
	 *  and ranging between the given from and to values.
	 *  @param bullet the bullet to which this marker will be applied
	 *  @param value the point value at which the marker should appear
	 */
	public BulletPointMarker(Bullet bullet, double value) {
	}

	/**
	 *  Constructs a BulletPointMarker for the specified Bullet, using the supplied fill value for the Color
	 *  and ranging between the given from and to values.
	 *  @param bullet the bullet to which this marker will be applied
	 *  @param fill the Color/Paint to use for filling in the body of the marker
	 *  @param value the point value at which the marker should appear
	 */
	public BulletPointMarker(Bullet bullet, java.awt.Paint fill, double value) {
	}

	/**
	 *  Returns the value that determines how much of the breadth of the bullet is covered by this marker
	 *  @return a value between 0 and 1
	 */
	public double getBreadthProportion() {
	}

	/**
	 *  Specify how much of the breadth of the bullet should be taken up by this marker. By default this is 0.75
	 *  @param breadthProportion a value between 0 and 1 (inclusive) (default 0.75)
	 */
	public void setBreadthProportion(double breadthProportion) {
	}

	/**
	 *  Returns the current Color (or other paint) for the body of the interval
	 *  @return the Paint for the body of the interval marker
	 */
	public java.awt.Paint getFill() {
	}

	/**
	 *  Specify the Color (or other Paint fill) to use for filling the body of the interval
	 *  @param fill the fill Color (or Paint) for the indicated range along the primary axis
	 */
	public void setFill(java.awt.Paint fill) {
	}

	/**
	 *  The method of the Drawable interface.
	 *  @param g the Graphics context
	 */
	@java.lang.Override
	public void draw(java.awt.Graphics g) {
	}
}
