/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A default implementation of the GaugeModel interface.
 *  A GaugeModel is essentially a set of <String, Positionable> pairs, where the string names the needle
 *  and the Positionable defines its position. There can be any number of these pairs, so there is no limit to
 *  the number of needles that can be displayed on a dial.
 */
public class DefaultGaugeModel implements GaugeModel {

	/**
	 *  Create an empty DefaultGaugeModel
	 */
	public DefaultGaugeModel() {
	}

	/**
	 *  Create a DefaultGaugeModel using the supplied string as the name of the model
	 *  @param name the name of the model
	 */
	public DefaultGaugeModel(String name) {
	}

	public void addGaugeModelListener(GaugeModelListener listener) {
	}

	public void removeGaugeModelListener(GaugeModelListener listener) {
	}

	protected void fireGaugeChanged(String needleName, Positionable pos) {
	}

	/**
	 *  returns the value of the needle with the supplied name
	 *  @param needleName the name of the needle of interest
	 *  @return the value of the needle
	 */
	public Positionable getValue(String needleName) {
	}

	/**
	 *  Specify the value for the given named needle.
	 *  @param needleName the name of the needle
	 *  @param value the numeric value of the needle
	 */
	public void setValue(String needleName, Double value) {
	}

	/**
	 *  Specify the value for the given named needle
	 *  @param needleName the name of the needle
	 *  @param value the value of the needle, expressed as a Positionable instance
	 */
	public void setValue(String needleName, Positionable value) {
	}

	/**
	 *  Specify the value for the given named needle but also supply a boolean to indicate
	 *  whether an event should be fired for the gauge to be updated. This can be useful to suppress
	 *  updates until all changes have been made.
	 *  @param needleName the name of the needle
	 *  @param value the value of the needle, expressed as a Positionable instance
	 *  @param fireUpdate a boolean to indicate whether updates should be fired
	 */
	public void setValue(String needleName, Positionable value, boolean fireUpdate) {
	}

	/**
	 *  Returns the number of needles/values in the model
	 *  @return the number of the needles/values in the model
	 */
	public int getValueCount() {
	}

	/**
	 *  Clears the values for all the needles
	 */
	public void clearValues() {
	}

	@java.lang.Override
	public boolean equals(Object o) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public String toString() {
	}
}
