/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  The main class for displaying circular gauges - or gauges that form part of a circle. The gauge class supports
 *  multiple needles, and you can configure the appearance of needles with a NeedleStyle.
 *  <p/>
 *  The dimensions of dial-related properties and needles are generally specified in terms of the radius of the dial so
 *  that the proportions of the dial objects remain unchanged under resizing. In other words, the same dial object will
 *  look good whether large or small.
 */
@java.lang.SuppressWarnings("serial")
public class Dial extends AbstractGauge {

	public static final String PROPERTY_DIAL_BACKGROUND = "Dial Background";

	/**
	 *  Create a new Dial instance.
	 */
	public Dial() {
	}

	public java.util.List getNeedleNames() {
	}

	public GaugeModel getAnimatedModel() {
	}

	public void setAnimatedModel(GaugeModel animatedModel) {
	}

	/**
	 *  Returns the primary axis for the dial
	 * 
	 *  @return the primary axis for the dial
	 */
	public DialAxis getAxis() {
	}

	/**
	 *  Specify the axis to use for the dial. The axis is used to specify properties such as inner and outer radius, fill
	 *  color and tick style
	 * 
	 *  @param axis the DialAxis instance
	 */
	public void setAxis(DialAxis axis) {
	}

	public void addAxis(DialAxis axis) {
	}

	public void removeAxis(DialAxis axis) {
	}

	/**
	 *  Adds a needle and associates it with the specified needle name
	 * 
	 *  @param needleName the name of the needle
	 *  @param style      the style to use when displaying the needle
	 */
	public void addNeedle(String needleName, NeedleStyle style) {
	}

	/**
	 *  Specify the style to use with the specified needle
	 * 
	 *  @param needleName the name of the needle
	 *  @param style      the display style associated with the needle
	 */
	public void setNeedleStyle(String needleName, NeedleStyle style) {
	}

	/**
	 *  Returns the display style associated with the specified needle
	 * 
	 *  @param needleName the name of the needle
	 *  @return the style associated with the named needle
	 */
	public NeedleStyle getNeedleStyle(String needleName) {
	}

	/**
	 *  Removes the named needle from the dial
	 * 
	 *  @param name the name of the needle to remove
	 */
	public void removeNeedle(String name) {
	}

	/**
	 *  Removes all needles from the dial
	 */
	public void removeNeedles() {
	}

	/**
	 *  Specify the needle renderer to use with the specified needle
	 * 
	 *  @param name     the needle whose renderer is being specified
	 *  @param renderer the renderer
	 */
	public void setNeedleRenderer(String name, NeedleRenderer renderer) {
	}

	/**
	 *  Remove the renderer associated with the specified needle
	 * 
	 *  @param name the name of the needle whose renderer is to be removed
	 */
	public void removeNeedleRenderer(String name) {
	}

	/**
	 *  Returns the needle renderer for the specified needle
	 * 
	 *  @param name the name of the needle
	 *  @return the associated needle renderer
	 */
	public NeedleRenderer getNeedleRenderer(String name) {
	}

	/**
	 *  Adds a Drawable object to the dial
	 * 
	 *  @param drawable the Drawable to add
	 *  @see DialIntervalMarker
	 *  @see DialLabel
	 */
	public void addDrawable(com.jidesoft.chart.Drawable drawable) {
	}

	/**
	 *  Removes the specified Drawable from the dial
	 * 
	 *  @param drawable the drawable to remove
	 */
	public void removeDrawable(com.jidesoft.chart.Drawable drawable) {
	}

	/**
	 *  Removes all Drawables from the dial
	 */
	public void removeDrawables() {
	}

	/**
	 *  Returns a boolean to indicate whether animation is being used to show needle changes
	 * 
	 *  @return a boolean to indicate whether animation is being used to show needle changes
	 */
	public boolean isAnimateOnChange() {
	}

	/**
	 *  Specify whether animation should be used to move needles when the value changes. When animation is being used,
	 *  the needle turns to the new value instead of changing instantly.
	 * 
	 *  @param animateOnChange whether to use animation to move needles
	 */
	public void setAnimateOnChange(boolean animateOnChange) {
	}

	public double getNeedleAnimationSpeed() {
	}

	public void setNeedleAnimationSpeed(double needleAnimationSpeed) {
	}

	public int getNeedleAnimationPeriod() {
	}

	public void setNeedleAnimationPeriod(int needleAnimationPeriod) {
	}

	/**
	 *  Set the value of the specified needle on the primary axis
	 * 
	 *  @param needleName the needle whose value we are setting
	 *  @param pos        a Positionable object that carries the value of the needle (and possibly other information
	 *                    too)
	 *  @param fireUpdate specify whether an update event should be fired on the model
	 */
	public void setValue(String needleName, Positionable pos, boolean fireUpdate) {
	}

	/**
	 *  Returns the base color of the face of the display
	 *  @return the base color of the face of the display
	 */
	public java.awt.Color getFaceColor() {
	}

	/**
	 *  Sets the base color of the face of the display
	 * 
	 *  @param faceColor the new color of the display
	 */
	public void setFaceColor(java.awt.Color faceColor) {
	}

	/**
	 *  The current Paint used for the face of the Dial.
	 *  @return the Paint used for the face of the Dial.
	 *  @see #setFacePaint
	 */
	public java.awt.Paint getFacePaint() {
	}

	/**
	 *  Sets the paint to use for filling the face of a Dial.
	 *  <p>Note that if you call setFacePaint with an instance of Color, the method derives a Paint based on the Color.
	 *  If you just want a plain Color, use setFaceColor instead.</p>
	 * 
	 *  @param facePaint the paint to use for the fill of the dial face
	 */
	public void setFacePaint(java.awt.Paint facePaint) {
	}

	/**
	 *  Specify the background to use for this dial. This is like the setBackground() method of JComponent, except that
	 *  you can supply a Paint instance rather than just a Color. This opens up the possibilities with gradient effects.
	 * 
	 *  @param background the background Paint
	 *  @deprecated in favour of setBackgroundPaint()
	 */
	public void setDialBackground(java.awt.Paint background) {
	}

	/**
	 *  Returns the dial background. If no paint instance has been set by calling setDialBackground() this method returns
	 *  the value of the inherited method getBackground() instead.
	 * 
	 *  @return the background Paint for the instance.
	 *  @deprecated in favour of getGaugeBackground()
	 */
	public java.awt.Paint getDialBackground() {
	}

	/**
	 *  @return the color of the ticks
	 */
	public java.awt.Color getTickColor() {
	}

	/**
	 *  Sets the color of the ticks (value markers) in the display
	 * 
	 *  @param tickColor the new color of the ticks in the display
	 */
	public void setTickColor(java.awt.Color tickColor) {
	}

	public double getStartAngle() {
	}

	/**
	 *  Sets the start angle for the gauge as a value in degrees
	 * 
	 *  @param startAngle an angle in degrees
	 */
	public void setStartAngle(double startAngle) {
	}

	public double getEndAngle() {
	}

	/**
	 *  Sets the end angle for the gauge as a value in degrees
	 * 
	 *  @param endAngle an angle in degrees
	 */
	public void setEndAngle(double endAngle) {
	}

	/**
	 *  Determines whether there is a needle at the specified pixel position. If there is, the name of the needle is
	 *  returned
	 * 
	 *  @param p the pixel point of enquiry
	 *  @return null if no needle is at the pixel point; otherwise a NeedleDescriptor that provides information about the
	 *          name and shape of the needle.
	 */
	public NeedleDescriptor needleAt(java.awt.geom.Point2D p) {
	}

	/**
	 *  Determines which needles, if any, are at the specified pixel position, returning a collection
	 *  of descriptor objects that describe the needles.
	 * 
	 *  @param p the pixel point of interest
	 *  @return a collection of NeedleDescriptor objects that specify which needles are at the supplied
	 *          pixel location
	 */
	public java.util.Collection needlesAt(java.awt.geom.Point2D p) {
	}

	/**
	 *  Returns a NeedleDescriptor object for the named needle
	 * 
	 *  @param needleName the name of the needle of interest
	 *  @return a NeedleDescriptor object for the named needle
	 */
	public NeedleDescriptor rendered(String needleName) {
	}

	/**
	 *  Returns the angle of the value on the primary axis
	 * 
	 *  @param value the value for which we compute the appropriate angle for drawing
	 *  @return an angle in degrees
	 */
	public Double getAngle(Double value) {
	}

	/**
	 *  Returns the angle (in degrees) of the value on the supplied axis, or null if the supplied value is null.
	 * 
	 *  @param axis  the axis context for the supplied value
	 *  @param value the value for which we compute the appropriate angle for drawing
	 *  @return an angle in degrees, or null if the supplied value is null
	 */
	public Double getAngle(DialAxis axis, Double value) {
	}

	/**
	 *  Reduces an angle value (given in degrees) to a value in the range [0, 360)
	 * 
	 *  @param angle an angle in degrees
	 *  @return an equivalent angle in degrees but in the range [0, 360)
	 */
	public static double normalizeAngle(double angle) {
	}

	protected java.awt.Paint deriveFacePaint(java.awt.Color faceColor, float x, float y, float radius) {
	}

	protected java.awt.geom.Point2D calculatePixelPoint2D(DialAxis axis, double axisValue) {
	}

	public DialFrame getFrame() {
	}

	public void setFrame(DialFrame frame) {
	}

	/**
	 *  Returns a radius in pixels
	 * 
	 *  @return the radius in pixels
	 */
	public float getRadius() {
	}

	public int getPivotX() {
	}

	public int getPivotY() {
	}

	/**
	 *  Update by forcing a re-drawing of the dial face
	 */
	public void update() {
	}

	/**
	 *  The main method for painting the display
	 */
	@java.lang.Override
	public void paintComponent(java.awt.Graphics g) {
	}

	public java.awt.geom.GeneralPath createSegment(double fromAngle, double toAngle, double innerRadius, double outerRadius) {
	}
}
