/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  The axis from which values are read on a Dial. You need to specify a start and end angle as well as a range.
 *  Start and end angles are given in degrees, with 0 being horizontal in the direction of East, and angles increasing
 *  in the anticlockwise direction. When specifying your start and end angles, you can make the end angle smaller than
 *  the start angle if you want the values on the axis to increase in a clockwise direction (for example a start angle
 *  of 180 and an end angle of 0).
 */
public class DialAxis extends AbstractNumericGaugeAxis {

	public static final String PROPERTY_INNER_RADIUS = "InnerRadius";

	public static final String PROPERTY_OUTER_RADIUS = "OuterRadius";

	public static final String PROPERTY_LABEL_RADIUS = "LabelRadius";

	/**
	 *  Default Constructor
	 */
	public DialAxis() {
	}

	/**
	 *  Create a DialAxis by specifying the start and end of the axis range
	 *  @param rangeStart the start of the axis range
	 *  @param rangeEnd the end of the axis range
	 */
	public DialAxis(double rangeStart, double rangeEnd) {
	}

	/**
	 *  Create a DialAxis by specifying the start and end of the axis range, as well as the major and minor tick
	 *  intervals
	 *  @param rangeStart the start of the axis range
	 *  @param rangeEnd the end of the axis range
	 *  @param majorTickInterval the distance between major ticks along the axis
	 *  @param minorTickInterval the distance between minor ticks along the axis
	 */
	public DialAxis(double rangeStart, double rangeEnd, double majorTickInterval, double minorTickInterval) {
	}

	/**
	 *  Returns the start angle of the axis in degrees
	 *  @return the start angle of the axis in degrees
	 */
	public double getStartAngle() {
	}

	/**
	 *  Sets the start angle of the axis in degrees
	 *  @param startAngle the startAngle of the axis (in degrees)
	 */
	public void setStartAngle(double startAngle) {
	}

	/**
	 *  Returns the end angle of the axis in degrees
	 *  @return the end angle of the axis in degrees
	 */
	public double getEndAngle() {
	}

	/**
	 *  Sets the end angle of the axis in degrees
	 *  @param endAngle the end angle of the axis in degrees
	 */
	public void setEndAngle(double endAngle) {
	}

	public double getInnerRadius() {
	}

	public void setInnerRadius(double innerRadius) {
	}

	public double getOuterRadius() {
	}

	public void setOuterRadius(double outerRadius) {
	}

	/**
	 *  Returns the orientation of the labels in relation to the dial face
	 *  @return the orientation of the labels
	 */
	public DialLabelOrientation getLabelOrientation() {
	}

	/**
	 *  Specify the orientation of the labels in relation to the dial face
	 *  @param labelOrientation the orientation of the labels
	 */
	public void setLabelOrientation(DialLabelOrientation labelOrientation) {
	}

	public double getLabelRadius() {
	}

	public void setLabelRadius(double labelRadius) {
	}

	public java.awt.Paint getFill() {
	}

	public void setFill(java.awt.Paint fill) {
	}

	public java.awt.Color getBorderColor() {
	}

	public void setBorderColor(java.awt.Color borderColor) {
	}

	public java.awt.BasicStroke getBorderStroke() {
	}

	public void setBorderStroke(java.awt.BasicStroke borderStroke) {
	}

	public double getRangeStart() {
	}

	public void setRangeStart(double start) {
	}

	public double getRangeEnd() {
	}

	public void setRangeEnd(double end) {
	}

	public boolean isTickLabelsVisible() {
	}

	public void setTickLabelsVisible(boolean tickLabelsVisible) {
	}
}
