/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A Paint for a Dial that allows you to specify which color(s) should appear at which angles, using
 *  the pivot point of the dial as the centre of the radius when computing the angles.
 * 
 *  Angles in between the specified angles are filled with a color derived as a linear gradient paint of the
 *  angle.
 * 
 *  Angles are specified in degrees between 0 and 360, or between -180 and 180 if you prefer.
 */
public class DialConicalPaint implements java.awt.Paint {

	/**
	 *  Construct a DialConicalPaint using the pivot point of the supplied Dial as the centre from which
	 *  to measure angles.
	 *  @param dial the dial from which the angles are measured
	 *  @param angles the angles (in degrees) that specify colors
	 *  @param colors the colors at the specified angles
	 */
	public DialConicalPaint(Dial dial, float[] angles, java.awt.Color[] colors) {
	}

	public java.awt.PaintContext createContext(java.awt.image.ColorModel colorModel, java.awt.Rectangle deviceBounds, java.awt.geom.Rectangle2D userBounds, java.awt.geom.AffineTransform transform, java.awt.RenderingHints hints) {
	}

	public int getTransparency() {
	}
}
