/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A Drawable class that paints a region to indicate an interval on the Dial's primary axis
 */
public class DialIntervalMarker implements com.jidesoft.chart.Drawable, com.jidesoft.chart.ZOrder {

	/**
	 *  Create a DialIntervalMarker for the supplied dial, between the values <code>fromValue</code> and <code>toValue</code>
	 *  on the primaryAxis and filled with the supplied paint fill.
	 *  @param dial the Dial to which the Marker will be added as a Drawable
	 *  @param fromValue the start value for the marker on the primary axis of the dial
	 *  @param toValue the end value for the marker on the primary axis of the dial
	 *  @param fill the paint fill
	 */
	public DialIntervalMarker(Dial dial, double fromValue, double toValue, java.awt.Paint fill) {
	}

	/**
	 *  Create a DialIntervalMarker for the supplied dial, between the values <code>fromValue</code> and <code>toValue</code>
	 *  on the primaryAxis, between the supplied <code>innerRadius</code> and <code>outerRadius</code> and filled with
	 *  the supplied paint fill.
	 *  @param dial the Dial to which the Marker will be added as a Drawable
	 *  @param fromValue the start value for the marker on the primary axis of the dial
	 *  @param toValue the end value for the marker on the primary axis of the dial
	 *  @param innerRadius the inner radius of the marker segment, supplied as a proportion of the dial radius
	 *  @param outerRadius the outer radius of the marker segment, supplied as a proportion of the dial radius
	 *  @param fill the paint fill
	 */
	public DialIntervalMarker(Dial dial, double fromValue, double toValue, double innerRadius, double outerRadius, java.awt.Paint fill) {
	}

	public java.awt.Paint getFill() {
	}

	public void setFill(java.awt.Paint fill) {
	}

	public double getFrom() {
	}

	public void setFrom(double from) {
	}

	public double getInnerRadius() {
	}

	public void setInnerRadius(double innerRadius) {
	}

	public double getOuterRadius() {
	}

	public void setOuterRadius(double outerRadius) {
	}

	public double getTo() {
	}

	public void setTo(double to) {
	}

	public java.awt.Color getBorderColor() {
	}

	public void setBorderColor(java.awt.Color borderColor) {
	}

	public java.awt.BasicStroke getBorderStroke() {
	}

	public void setBorderStroke(java.awt.BasicStroke borderStroke) {
	}

	public int getZOrder() {
	}

	public void setZOrder(int zOrder) {
	}

	public void draw(java.awt.Graphics g) {
	}

	public java.awt.geom.GeneralPath createSegment(double fromAngle, double toAngle, double innerRadius, double outerRadius) {
	}
}
