/**
 *  Contains gauge classes such as Dial and Clock, and other associated classes for styling and appearance.
 */
package com.jidesoft.gauge;


/**
 *  A Drawable class that can be used to add text to a Dial.
 * 
 *  @see Dial#addDrawable
 */
public class DialLabel implements com.jidesoft.chart.Drawable {

	/**
	 *  Create a textual label to add to a dial
	 *  @param dial the dial to which the label will be added
	 *  @param radius the radius at which the label will be placed, as a proportion of the radius of the dial
	 *  @param angle the angle at which the label will be placed, in degrees
	 *  @param label the text of the label
	 */
	public DialLabel(Dial dial, double radius, double angle, String label) {
	}

	/**
	 *  Returns the color of the text of the label
	 *  @return the color of the text of the label
	 */
	public java.awt.Color getColor() {
	}

	/**
	 *  Specify the color of the text of the label
	 *  @param color the color of the text of the label
	 */
	public void setColor(java.awt.Color color) {
	}

	/**
	 *  Returns the font being used for the label
	 *  @return the font used for the label
	 */
	public java.awt.Font getFont() {
	}

	/**
	 *  Specify the font used for the label
	 *  @param font the font used for the label
	 */
	public void setFont(java.awt.Font font) {
	}

	/**
	 *  Returns the text of the label
	 *  @return the text of the label
	 */
	public String getLabel() {
	}

	/**
	 *  Specify the text of the label
	 *  @param label the text of the label
	 */
	public void setLabel(String label) {
	}

	/**
	 *  Returns the angle at which the label will be positioned
	 *  @return the angle at which the label will be positioned
	 */
	public double getAngle() {
	}

	/**
	 *  Specify the angle at which the label will be positioned
	 *  @param angle the angle at which the label will be positioned
	 */
	public void setAngle(double angle) {
	}

	/**
	 *  Returns the radius at which the label will be positioned
	 *  @return the radius at which the label will be positioned
	 */
	public double getRadius() {
	}

	/**
	 *  Specify the radius at which the label will be positioned
	 *  @param radius the radius at which the label will be positioned
	 */
	public void setRadius(double radius) {
	}

	/**
	 *  The method of the Drawable interface that paints the label
	 *  @param g the Graphics context
	 */
	public void draw(java.awt.Graphics g) {
	}
}
